/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;

public abstract class AbstractActivity
implements Activity {
    protected PlaceManager placeManager;
    protected PlaceRequest place;
    protected boolean open = false;

    public AbstractActivity(PlaceManager placeManager) {
        this.placeManager = placeManager;
    }

    @Override
    public void onStartup(PlaceRequest place) {
        this.place = (PlaceRequest)PortablePreconditions.checkNotNull((String)"place", (Object)place);
    }

    @Override
    public void onOpen() {
        if (this.place == null) {
            throw new IllegalStateException("Activity " + this + " has not been started");
        }
        if (this.open) {
            throw new IllegalStateException("Activity " + this + " already open");
        }
        this.open = true;
        this.placeManager.executeOnOpenCallbacks(this.place);
    }

    @Override
    public void onClose() {
        if (this.place == null) {
            throw new IllegalStateException("Activity " + this + " has not been started");
        }
        if (!this.open) {
            throw new IllegalStateException("Activity " + this + " not open");
        }
        this.open = false;
        this.placeManager.executeOnCloseCallbacks(this.place);
    }

    @Override
    public void onShutdown() {
        if (this.place == null) {
            throw new IllegalStateException("Activity " + this + " has not been started");
        }
        if (this.open) {
            throw new IllegalStateException("Activity " + this + " is open");
        }
        this.place = null;
    }

    @Override
    public PlaceRequest getPlace() {
        return this.place;
    }

    public String toString() {
        return this.getClass().getName() + (this.place == null ? " (not started)" : " for " + this.place);
    }
}

