/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.EnabledByProperty;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityAndMetaInfo;
import org.uberfire.client.mvp.ActivityMetaInfo;
import org.uberfire.client.mvp.IsSplashScreen;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.events.NewWorkbenchScreenEvent;
import org.uberfire.commons.data.Pair;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;

@ApplicationScoped
@EnabledByProperty(value="uberfire.plugin.mode.active", negated=true)
public class ActivityBeansCache {
    private final Map<String, SyncBeanDef<Activity>> activitiesById = new HashMap<String, SyncBeanDef<Activity>>();
    private final List<SplashScreenActivity> splashActivities = new ArrayList<SplashScreenActivity>();
    private SyncBeanManager iocManager;
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    private Event<NewWorkbenchScreenEvent> newWorkbenchScreenEventEvent;
    protected ResourceTypeManagerCache resourceTypeManagerCache;
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;

    public ActivityBeansCache() {
    }

    @Inject
    public ActivityBeansCache(SyncBeanManager iocManager, Event<NewPerspectiveEvent> newPerspectiveEventEvent, Event<NewWorkbenchScreenEvent> newWorkbenchScreenEventEvent, ResourceTypeManagerCache resourceTypeManagerCache, ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager) {
        this.iocManager = iocManager;
        this.newPerspectiveEventEvent = newPerspectiveEventEvent;
        this.newWorkbenchScreenEventEvent = newWorkbenchScreenEventEvent;
        this.resourceTypeManagerCache = resourceTypeManagerCache;
        this.experimentalActivitiesAuthorizationManager = experimentalActivitiesAuthorizationManager;
    }

    @PostConstruct
    void init() {
        Collection<SyncBeanDef<Activity>> availableActivities = this.getAvailableActivities();
        for (SyncBeanDef<Activity> activityBean : availableActivities) {
            String id = activityBean.getName();
            this.validateUniqueness(id);
            this.activitiesById.put(id, activityBean);
            if (this.isSplashScreen(activityBean.getQualifiers())) {
                this.splashActivities.add((SplashScreenActivity)activityBean.getInstance());
                continue;
            }
            Pair<Integer, List<String>> metaInfo = this.generateActivityMetaInfo(activityBean);
            if (metaInfo == null) continue;
            this.addResourceActivity(activityBean, metaInfo);
        }
        this.resourceTypeManagerCache.sortResourceActivitiesByPriority();
    }

    private void addResourceActivity(SyncBeanDef<Activity> activityBean, Pair<Integer, List<String>> metaInfo) {
        ActivityAndMetaInfo activityAndMetaInfo = new ActivityAndMetaInfo(this.iocManager, activityBean, (Integer)metaInfo.getK1(), (List)metaInfo.getK2());
        this.resourceTypeManagerCache.addResourceActivity(activityAndMetaInfo);
    }

    Collection<SyncBeanDef<Activity>> getAvailableActivities() {
        ArrayList<SyncBeanDef<Activity>> activeBeans = new ArrayList<SyncBeanDef<Activity>>();
        for (SyncBeanDef bean : this.iocManager.lookupBeans(Activity.class)) {
            if (!bean.isActivated()) continue;
            activeBeans.add((SyncBeanDef<Activity>)bean);
        }
        return activeBeans;
    }

    private boolean isSplashScreen(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!(qualifier instanceof IsSplashScreen)) continue;
            return true;
        }
        return false;
    }

    public void removeActivity(String id) {
        this.activitiesById.remove(id);
    }

    public void addNewScreenActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.newWorkbenchScreenEventEvent.fire((Object)new NewWorkbenchScreenEvent(id));
    }

    private void validateUniqueness(String id) {
        if (this.activitiesById.keySet().contains(id)) {
            throw new RuntimeException("Conflict detected: Activity already exists with id " + id);
        }
    }

    public void addNewPerspectiveActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.newPerspectiveEventEvent.fire((Object)new NewPerspectiveEvent(id));
    }

    public void addNewEditorActivity(SyncBeanDef<Activity> activityBean, String priority, String resourceTypeName) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.resourceTypeManagerCache.addResourceActivity(new ActivityAndMetaInfo(this.iocManager, activityBean, Integer.valueOf(priority), Arrays.asList(resourceTypeName)));
        this.resourceTypeManagerCache.sortResourceActivitiesByPriority();
    }

    public void addNewSplashScreenActivity(SyncBeanDef<Activity> activityBean) {
        String id = activityBean.getName();
        this.validateUniqueness(id);
        this.activitiesById.put(id, activityBean);
        this.splashActivities.add((SplashScreenActivity)activityBean.getInstance());
    }

    public boolean hasActivity(String id) {
        return this.activitiesById.containsKey(id);
    }

    public List<SplashScreenActivity> getSplashScreens() {
        return this.splashActivities;
    }

    public SyncBeanDef<Activity> getActivity(String id) {
        return this.activitiesById.get(id);
    }

    public SyncBeanDef<Activity> getActivity(Path path) {
        Optional<ActivityAndMetaInfo> optional = this.resourceTypeManagerCache.getResourceActivities().stream().filter(activityAndMetaInfo -> this.activitySupportsPath((ActivityAndMetaInfo)activityAndMetaInfo, path)).findAny();
        if (optional.isPresent()) {
            return optional.get().getActivityBean();
        }
        throw new EditorResourceTypeNotFound();
    }

    private boolean activitySupportsPath(ActivityAndMetaInfo activity, Path path) {
        if (this.experimentalActivitiesAuthorizationManager.authorizeActivityClass(activity.getActivityBean().getBeanClass())) {
            return Stream.of(activity.getResourceTypes()).anyMatch(clientResourceType -> clientResourceType.accept(path));
        }
        return false;
    }

    public List<SyncBeanDef<Activity>> getPerspectiveActivities() {
        ArrayList<SyncBeanDef<Activity>> results = new ArrayList<SyncBeanDef<Activity>>();
        for (SyncBeanDef<Activity> beanDef : this.activitiesById.values()) {
            if (!beanDef.isAssignableTo(PerspectiveActivity.class)) continue;
            results.add(beanDef);
        }
        return results;
    }

    Pair<Integer, List<String>> generateActivityMetaInfo(SyncBeanDef<Activity> activityBean) {
        return ActivityMetaInfo.generate(activityBean);
    }

    public List<String> getActivitiesById() {
        return new ArrayList<String>(this.activitiesById.keySet());
    }

    public class EditorResourceTypeNotFound
    extends RuntimeException {
    }
}

