/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.inject.Instance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.mvp.AbstractWorkbenchEditorActivity;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.ExternalPathPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchEditorActivityTest {
    @Mock
    private Instance<LockManager> lockManagerProvider;
    @Mock
    private LockManager lockManager;
    @Mock
    private PathPlaceRequest place;
    @Mock
    private ObservablePath path;
    @Mock
    private ExternalPathPlaceRequest extPlace;
    @Mock
    private Path plainPath;
    @Mock
    private IsWidget isWidget;
    @Mock
    private PlaceManager placeManager;

    @Before
    public void setup() {
        Mockito.when((Object)this.lockManagerProvider.get()).thenReturn((Object)this.lockManager);
        Mockito.when((Object)this.place.getPath()).thenReturn((Object)this.path);
    }

    @Test
    public void editorProvidedLockingDoesNotAcquireLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManagerProvider, this.placeManager, WorkbenchEditor.LockingStrategy.EDITOR_PROVIDED);
        activity.onStartup((PlaceRequest)this.place);
        activity.onOpen();
        ((Instance)Mockito.verify(this.lockManagerProvider, (VerificationMode)Mockito.never())).get();
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).acquireLockOnDemand();
    }

    @Test
    public void editorProvidedLockingDoesNotReleasesLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManagerProvider, this.placeManager, WorkbenchEditor.LockingStrategy.EDITOR_PROVIDED);
        activity.onStartup((PlaceRequest)this.place);
        activity.onOpen();
        activity.onClose();
        ((Instance)Mockito.verify(this.lockManagerProvider, (VerificationMode)Mockito.never())).destroy(Matchers.eq((Object)this.lockManager));
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).releaseLock();
    }

    @Test
    public void frameworkProvidedLockingAcquiresLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManagerProvider, this.placeManager, WorkbenchEditor.LockingStrategy.FRAMEWORK_PESSIMISTIC);
        activity.onStartup((PlaceRequest)this.place);
        activity.onOpen();
        ((Instance)Mockito.verify(this.lockManagerProvider, (VerificationMode)Mockito.times((int)1))).get();
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).acquireLockOnDemand();
    }

    @Test
    public void frameworkProvidedLockingReleasesLocks() {
        EditorTestActivity activity = new EditorTestActivity(this.lockManagerProvider, this.placeManager, WorkbenchEditor.LockingStrategy.FRAMEWORK_PESSIMISTIC);
        activity.onStartup((PlaceRequest)this.place);
        activity.onOpen();
        activity.onClose();
        ((Instance)Mockito.verify(this.lockManagerProvider, (VerificationMode)Mockito.times((int)1))).destroy(Matchers.eq((Object)this.lockManager));
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
    }

    @Test
    public void editorCreatesObservablePathForExternalPlaceRequest() {
        EditorTestActivity activity = (EditorTestActivity)((Object)Mockito.spy((Object)((Object)new EditorTestActivity(this.lockManagerProvider, this.placeManager, WorkbenchEditor.LockingStrategy.EDITOR_PROVIDED))));
        ((EditorTestActivity)((Object)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                return null;
            }
        }).when((Object)activity))).onStartup((Path)Mockito.any(Path.class), (PlaceRequest)Mockito.any(PlaceRequest.class));
        Mockito.when((Object)this.extPlace.getPath()).thenReturn((Object)this.plainPath);
        activity.onStartup((PlaceRequest)this.extPlace);
        ((EditorTestActivity)((Object)Mockito.verify((Object)((Object)activity)))).onStartup((Path)Mockito.any(Path.class), (PlaceRequest)Mockito.any(PlaceRequest.class));
    }

    private class EditorTestActivity
    extends AbstractWorkbenchEditorActivity {
        private WorkbenchEditor.LockingStrategy strategy;

        public EditorTestActivity(Instance<LockManager> lockManagerProvider, PlaceManager placeManager, WorkbenchEditor.LockingStrategy strategy) {
            super(placeManager);
            this.lockManagerProvider = lockManagerProvider;
            this.strategy = strategy;
        }

        public String getIdentifier() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public IsWidget getWidget() {
            return WorkbenchEditorActivityTest.this.isWidget;
        }

        protected WorkbenchEditor.LockingStrategy getLockingStrategy() {
            return this.strategy;
        }

        public boolean isDynamic() {
            return true;
        }
    }
}

