/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.CanBeDisabled;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.HasChildren;
import org.uberfire.client.workbench.widgets.menu.megamenu.brand.MegaMenuBrand;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMegaMenuPresenterTest {
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    protected User identity;
    @Mock
    private ManagedInstance<MegaMenuBrand> megaMenuBrands;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    @Mock
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    @Mock
    private Workbench workbench;
    @Mock
    private WorkbenchMegaMenuPresenter.View view;
    private WorkbenchMegaMenuPresenter presenter;

    @Before
    public void setup() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isUnsatisfied();
        this.presenter = (WorkbenchMegaMenuPresenter)Mockito.spy((Object)new WorkbenchMegaMenuPresenter(this.authzManager, this.perspectiveManager, this.activityManager, this.identity, this.view, this.megaMenuBrands, this.placeManager, this.authorizationManager, this.sessionInfo, this.childMenuItemPresenters, this.groupMenuItemPresenters, this.childContextMenuItemPresenters, this.groupContextMenuItemPresenters, this.workbench));
        Mockito.reset((Object[])new WorkbenchMegaMenuPresenter.View[]{this.view});
        this.presenter.selectableMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        this.presenter.hasChildrenMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        this.presenter.canBeDisabledMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(ChildMenuItemPresenter.class)).when(this.childMenuItemPresenters)).get();
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(GroupMenuItemPresenter.class)).when(this.groupMenuItemPresenters)).get();
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(ChildContextMenuItemPresenter.class)).when(this.childContextMenuItemPresenters)).get();
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(GroupContextMenuItemPresenter.class)).when(this.groupContextMenuItemPresenters)).get();
    }

    @Test
    public void testAddCurrentPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddPerspective() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("anyId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).selectMenuItem("perspectiveId");
    }

    @Test
    public void testPerspectiveChangeEvent() {
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"test").perspective("perspectiveId")).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("perspectiveId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveChange perspectiveChange = new PerspectiveChange((PlaceRequest)placeRequest, null, null, "perspectiveId");
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)perspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        this.presenter.onPerspectiveChange(perspectiveChange);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).selectMenuItem("perspectiveId");
    }

    @Test
    public void testAddMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).addMenuItem((String)Matchers.eq((Object)"perspectiveId"), (String)Matchers.eq((Object)"perspectiveLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)false);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addMenuItem((String)Matchers.eq((Object)"perspectiveId"), (String)Matchers.eq((Object)"perspectiveLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenuWithPermission() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        MenuPosition position = MenuPosition.LEFT;
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).addContextMenuItem((String)Matchers.eq((Object)"perspectiveId"), Matchers.anyString(), (String)Matchers.eq((Object)"contextLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.eq((Object)position));
    }

    @Test
    public void testAddContextMenuWithoutPermission() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addContextMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testSetupEnableDisableMenuItemCommand() {
        String label = "command";
        Command command = (Command)Mockito.mock(Command.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"command").respondsWith(command)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPlace() {
        String label = "placeLabel";
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"placeLabel").place(place)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPerspective() {
        String label = "perspectiveLabel";
        String perspectiveId = "perspectiveId";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableContextMenuItem() {
        String contextLabel = "contextLabel";
        String perspectiveId = "perspectiveId";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        Mockito.when((Object)activity.getMenus()).thenReturn((Object)contextMenus);
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testMenuInsertionOrder() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus firstMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Menus secondMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(1)).perspective("perspectiveId")).endMenu()).build();
        Menus thirdMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(2)).perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)firstMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)secondMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)thirdMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(thirdMenus);
        this.presenter.addMenus(firstMenus);
        this.presenter.addMenus(secondMenus);
        Assert.assertEquals((long)3L, (long)this.presenter.getAddedMenus().size());
        Assert.assertSame((Object)firstMenus, this.presenter.getAddedMenus().get(0));
        Assert.assertSame((Object)secondMenus, this.presenter.getAddedMenus().get(1));
        Assert.assertSame((Object)thirdMenus, this.presenter.getAddedMenus().get(2));
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test(expected=RuntimeException.class)
    public void setupWithMoreThanOneMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isAmbiguous();
        this.presenter.setup();
    }

    @Test
    public void setupWithNoMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isUnsatisfied();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).hideBrand();
    }

    @Test
    public void setupWithOneEmptyMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isAmbiguous();
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isUnsatisfied();
        MegaMenuBrandMock megaMenuBrand = new MegaMenuBrandMock("", "", "");
        ((ManagedInstance)Mockito.doReturn((Object)megaMenuBrand).when(this.megaMenuBrands)).get();
        ((WorkbenchMegaMenuPresenter.View)Mockito.doReturn((Object)"defaultMenuText").when((Object)this.view)).getDefaultMenuText();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setBrandImage(Matchers.anyString());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setBrandImageTitle(Matchers.anyString());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).hideBrand();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setMenuAccessorText(this.view.getDefaultMenuText());
    }

    @Test
    public void setupWithOneMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isAmbiguous();
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isUnsatisfied();
        MegaMenuBrandMock megaMenuBrand = new MegaMenuBrandMock("brandImageUrl", "brandImageLabel", "menuAccessorLabel");
        ((ManagedInstance)Mockito.doReturn((Object)megaMenuBrand).when(this.megaMenuBrands)).get();
        ((WorkbenchMegaMenuPresenter.View)Mockito.doReturn((Object)"defaultMenuText").when((Object)this.view)).getDefaultMenuText();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImage(megaMenuBrand.brandImageUrl());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImageTitle(megaMenuBrand.brandImageLabel());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideBrand();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setMenuAccessorText(megaMenuBrand.menuAccessorLabel());
    }

    @Test
    public void addMenuItemWithParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        HasChildren parent = (HasChildren)Mockito.mock(HasChildren.class);
        this.presenter.hasChildrenMenuItemByIdentifier.put("parentId", parent);
        this.presenter.addMenuItem("id", "label", "parentId", (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)Matchers.eq((Object)"label"), (Command)Matchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnParent(childMenuItemPresenter, parent);
    }

    @Test
    public void addMenuItemOnTheRightWithoutParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ChildMenuItemPresenter)Mockito.doReturn((Object)Mockito.mock(ChildMenuItemPresenter.View.class)).when((Object)childMenuItemPresenter)).getView();
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        this.presenter.addMenuItem("id", "label", null, (Command)Mockito.mock(Command.class), MenuPosition.RIGHT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)Matchers.eq((Object)"label"), (Command)Matchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnRight(childMenuItemPresenter);
    }

    @Test
    public void addMenuItemOnTheLeftWithoutParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ChildMenuItemPresenter)Mockito.doReturn((Object)Mockito.mock(ChildMenuItemPresenter.View.class)).when((Object)childMenuItemPresenter)).getView();
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        this.presenter.addMenuItem("id", "label", null, (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)Matchers.eq((Object)"label"), (Command)Matchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnLeft(childMenuItemPresenter);
    }

    @Test
    public void addCustomIsElementMenuItemTest() {
        IsElement menu = (IsElement)Mockito.mock(IsElement.class);
        this.presenter.addCustomMenuItem((org.jboss.errai.common.client.api.IsElement)menu, MenuPosition.RIGHT);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addCustomMenuItem((org.jboss.errai.common.client.api.IsElement)menu);
    }

    @Test
    public void addCustomIsWidgetMenuItemTest() {
        IsWidget menu = (IsWidget)Mockito.mock(IsWidget.class);
        this.presenter.addCustomMenuItem(menu, MenuPosition.RIGHT);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addCustomMenuItem(menu);
    }

    @Test
    public void addGroupMenuItemTest() {
        GroupMenuItemPresenter groupMenuItemPresenter = (GroupMenuItemPresenter)Mockito.mock(GroupMenuItemPresenter.class);
        ((GroupMenuItemPresenter)Mockito.doReturn((Object)Mockito.mock(GroupMenuItemPresenter.View.class)).when((Object)groupMenuItemPresenter)).getView();
        ((ManagedInstance)Mockito.doReturn((Object)groupMenuItemPresenter).when(this.groupMenuItemPresenters)).get();
        this.presenter.addGroupMenuItem("id", "label", MenuPosition.LEFT);
        ((GroupMenuItemPresenter)Mockito.verify((Object)groupMenuItemPresenter)).setup((String)Matchers.eq((Object)"label"));
        ((Map)Mockito.verify((Object)this.presenter.hasChildrenMenuItemByIdentifier)).put("id", groupMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addGroupMenuItem(groupMenuItemPresenter);
    }

    @Test
    public void addContextMenuItemTest() {
        ChildContextMenuItemPresenter childContextMenuItemPresenter = (ChildContextMenuItemPresenter)Mockito.mock(ChildContextMenuItemPresenter.class);
        ((ChildContextMenuItemPresenter)Mockito.doReturn((Object)Mockito.mock(ChildContextMenuItemPresenter.View.class)).when((Object)childContextMenuItemPresenter)).getView();
        ((ManagedInstance)Mockito.doReturn((Object)childContextMenuItemPresenter).when(this.childContextMenuItemPresenters)).get();
        HasChildren parent = (HasChildren)Mockito.mock(HasChildren.class);
        this.presenter.hasChildrenMenuItemByIdentifier.put("parentId", parent);
        this.presenter.addContextMenuItem("menuItemId", "id", "label", "parentId", (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildContextMenuItemPresenter)Mockito.verify((Object)childContextMenuItemPresenter)).setup((String)Matchers.eq((Object)"label"), (Command)Matchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childContextMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItemOnParent(childContextMenuItemPresenter, parent);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setContextMenuActive(true);
    }

    @Test
    public void addContextGroupMenuItemTest() {
        GroupContextMenuItemPresenter groupContextMenuItemPresenter = (GroupContextMenuItemPresenter)Mockito.mock(GroupContextMenuItemPresenter.class);
        ((GroupContextMenuItemPresenter)Mockito.doReturn((Object)Mockito.mock(GroupContextMenuItemPresenter.View.class)).when((Object)groupContextMenuItemPresenter)).getView();
        ((ManagedInstance)Mockito.doReturn((Object)groupContextMenuItemPresenter).when(this.groupContextMenuItemPresenters)).get();
        this.presenter.addContextGroupMenuItem("menuItemId", "id", "label", MenuPosition.LEFT);
        ((GroupContextMenuItemPresenter)Mockito.verify((Object)groupContextMenuItemPresenter)).setup("label");
        ((Map)Mockito.verify((Object)this.presenter.hasChildrenMenuItemByIdentifier)).put("id", groupContextMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", groupContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItem(groupContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setContextMenuActive(true);
    }

    @Test
    public void clearContextMenuTest() {
        this.view.clearContextMenu();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
    }

    @Test
    public void enableMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableMenuItem("id", true);
        ((CanBeDisabled)Mockito.verify((Object)menuItem)).enable();
    }

    @Test
    public void disableMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableMenuItem("id", false);
        ((CanBeDisabled)Mockito.verify((Object)menuItem)).disable();
    }

    @Test
    public void enableContextMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableContextMenuItem("id", true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem("id", true);
    }

    @Test
    public void setupHomeLinkWithNoDefaultPerspective() {
        ((Workbench)Mockito.doReturn(null).when((Object)this.workbench)).getHomePerspectiveActivity();
        ((WorkbenchMegaMenuPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasAccessToPerspective((String)Matchers.any());
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo(Matchers.anyString());
    }

    @Test
    public void setupHomeLinkWithNoPermissionToAccessDefaultPerspective() {
        PerspectiveActivity homePerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((PerspectiveActivity)Mockito.doReturn((Object)"identifier").when((Object)homePerspective)).getIdentifier();
        ((Workbench)Mockito.doReturn((Object)homePerspective).when((Object)this.workbench)).getHomePerspectiveActivity();
        ((WorkbenchMegaMenuPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasAccessToPerspective((String)Matchers.any());
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo(Matchers.anyString());
    }

    @Test
    public void setupHomeLinkWithPermissionToAccessDefaultPerspective() {
        PerspectiveActivity homePerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((PerspectiveActivity)Mockito.doReturn((Object)"identifier").when((Object)homePerspective)).getIdentifier();
        ((Workbench)Mockito.doReturn((Object)homePerspective).when((Object)this.workbench)).getHomePerspectiveActivity();
        ((WorkbenchMegaMenuPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasAccessToPerspective((String)Matchers.any());
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("identifier");
    }

    class MegaMenuBrandMock
    implements MegaMenuBrand {
        private String brandImageUrl;
        private String brandImageLabel;
        private String menuAccessorLabel;

        public MegaMenuBrandMock(String brandImageUrl, String brandImageLabel, String menuAccessorLabel) {
            this.brandImageUrl = brandImageUrl;
            this.brandImageLabel = brandImageLabel;
            this.menuAccessorLabel = menuAccessorLabel;
        }

        public String brandImageUrl() {
            return this.brandImageUrl;
        }

        public String brandImageLabel() {
            return this.brandImageLabel;
        }

        public String menuAccessorLabel() {
            return this.menuAccessorLabel;
        }
    }
}

