/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarProducer;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarStandalonePresenter;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMenuBarProducerTest {
    @Mock
    private AuthorizationManager authzManager;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private User identity;
    @Mock
    private WorkbenchMenuBarPresenter.View view;
    @Mock
    private WorkbenchMenuBarPresenter defaultPresenter;
    @Mock
    private WorkbenchMenuBarStandalonePresenter standalonePresenter;
    @Mock
    private PerspectiveChange perspectiveChangeEvent;
    @Mock
    private PlaceMaximizedEvent placeMaximizedEvent;
    @Mock
    private PlaceMinimizedEvent placeMinimizedEvent;
    private WorkbenchMenuBarProducer producer;
    private boolean isStandalone = false;

    @Before
    public void setup() {
        this.producer = new WorkbenchMenuBarProducer(this.authzManager, this.perspectiveManager, this.placeManager, this.activityManager, this.identity, this.view){

            boolean isStandalone() {
                return WorkbenchMenuBarProducerTest.this.isStandalone;
            }

            WorkbenchMenuBarPresenter makeDefaultMenuBarPresenter() {
                return WorkbenchMenuBarProducerTest.this.defaultPresenter;
            }

            WorkbenchMenuBarPresenter makeStandaloneMenuBarPresenter() {
                return WorkbenchMenuBarProducerTest.this.standalonePresenter;
            }
        };
    }

    @Test
    public void menuBarPresenterInstantiationDefaultMode() {
        this.assertMenuBarPresenter(false, WorkbenchMenuBarPresenter.class);
    }

    @Test
    public void menuBarPresenterInstantiationStandaloneMode() {
        this.assertMenuBarPresenter(true, WorkbenchMenuBarStandalonePresenter.class);
    }

    @Test
    public void checkObservedEventsCallsPresenterDefaultMode() {
        WorkbenchMenuBarPresenter presenter = this.getMenuBarPresenter(false);
        this.assertMenuBarEvents(presenter);
    }

    @Test
    public void checkObservedEventsCallsPresenterStandaloneMode() {
        WorkbenchMenuBarPresenter presenter = this.getMenuBarPresenter(true);
        this.assertMenuBarEvents(presenter);
    }

    private void assertMenuBarPresenter(boolean isStandalone, Class expectedPresenterType) {
        WorkbenchMenuBarPresenter presenter = this.getMenuBarPresenter(isStandalone);
        Assert.assertEquals((Object)this.extractContainingClassName(expectedPresenterType.getName()), (Object)this.extractContainingClassName(presenter.getClass().getName()));
    }

    private void assertMenuBarEvents(WorkbenchMenuBarPresenter presenter) {
        presenter.onPerspectiveChange(this.perspectiveChangeEvent);
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)presenter)).onPerspectiveChange((PerspectiveChange)Matchers.eq((Object)this.perspectiveChangeEvent));
        presenter.onPlaceMaximized(this.placeMaximizedEvent);
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)presenter)).onPlaceMaximized((PlaceMaximizedEvent)Matchers.eq((Object)this.placeMaximizedEvent));
        presenter.onPlaceMinimized(this.placeMinimizedEvent);
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)presenter)).onPlaceMinimized((PlaceMinimizedEvent)Matchers.eq((Object)this.placeMinimizedEvent));
    }

    private WorkbenchMenuBarPresenter getMenuBarPresenter(boolean isStandalone) {
        this.isStandalone = isStandalone;
        return this.producer.getWorkbenchMenuBar();
    }

    private String extractContainingClassName(String className) {
        if (className.contains("$$")) {
            return className.substring(0, className.indexOf("$$"));
        }
        return className;
    }
}

