/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import com.google.gwt.user.client.Window;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarStandalonePresenter;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class WorkbenchMenuBarProducer {
    private AuthorizationManager authzManager;
    private PerspectiveManager perspectiveManager;
    private PlaceManager placeManager;
    private ActivityManager activityManager;
    private User identity;
    private WorkbenchMenuBarPresenter.View view;
    private WorkbenchMenuBarPresenter instance = null;

    public WorkbenchMenuBarProducer() {
    }

    @Inject
    public WorkbenchMenuBarProducer(AuthorizationManager authzManager, PerspectiveManager perspectiveManager, PlaceManager placeManager, ActivityManager activityManager, User identity, WorkbenchMenuBarPresenter.View view) {
        this.authzManager = authzManager;
        this.perspectiveManager = perspectiveManager;
        this.placeManager = placeManager;
        this.activityManager = activityManager;
        this.identity = identity;
        this.view = view;
    }

    @Produces
    public WorkbenchMenuBarPresenter getWorkbenchMenuBar() {
        if (this.instance == null) {
            this.instance = !this.isStandalone() ? this.makeDefaultMenuBarPresenter() : this.makeStandaloneMenuBarPresenter();
        }
        return this.instance;
    }

    WorkbenchMenuBarPresenter makeDefaultMenuBarPresenter() {
        return new WorkbenchMenuBarPresenter(this.authzManager, this.perspectiveManager, this.placeManager, this.activityManager, this.identity, this.view);
    }

    WorkbenchMenuBarPresenter makeStandaloneMenuBarPresenter() {
        return new WorkbenchMenuBarStandalonePresenter(this.authzManager, this.perspectiveManager, this.placeManager, this.activityManager, this.identity, this.view);
    }

    protected void onPerspectiveChange(@Observes PerspectiveChange perspectiveChange) {
        if (this.instance != null) {
            this.instance.onPerspectiveChange(perspectiveChange);
        }
    }

    protected void onPlaceMinimized(@Observes PlaceMinimizedEvent event) {
        if (this.instance != null) {
            this.instance.onPlaceMinimized(event);
        }
    }

    protected void onPlaceMaximized(@Observes PlaceMaximizedEvent event) {
        if (this.instance != null) {
            this.instance.onPlaceMaximized(event);
        }
    }

    boolean isStandalone() {
        return Window.Location.getParameterMap().containsKey("standalone");
    }
}

