/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.events.NewWorkbenchScreenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.workbench.category.Category;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceTypeManagerCacheTest {
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    @Mock
    private Event<NewWorkbenchScreenEvent> newWorkbenchScreenEvent;
    @Mock
    private CategoriesManagerCache categoriesManagerCache;
    private ResourceTypeManagerCache resourceTypeManagerCache;
    private ActivityBeansCache activityBeansCache;

    @Before
    public void setUp() {
        this.resourceTypeManagerCache = new ResourceTypeManagerCache(this.categoriesManagerCache);
        this.activityBeansCache = new ActivityBeansCache(this.iocManager, this.newPerspectiveEventEvent, this.newWorkbenchScreenEvent, this.resourceTypeManagerCache);
    }

    @Test
    public void testGetResourceTypeDefinitions() {
        Category process = (Category)Mockito.mock(Category.class);
        Category model = (Category)Mockito.mock(Category.class);
        Mockito.when((Object)process.getName()).thenReturn((Object)"PROCESS");
        Mockito.when((Object)model.getName()).thenReturn((Object)"MODEL");
        ClientResourceType clientResourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        Mockito.when((Object)clientResourceType.getCategory()).thenReturn((Object)model);
        SyncBeanDef syncBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)syncBeanDef.getInstance()).thenReturn((Object)clientResourceType);
        List<SyncBeanDef> resourceTypeBeans = Arrays.asList(syncBeanDef);
        Mockito.when((Object)this.iocManager.lookupBeans((String)Matchers.eq((Object)"java"))).thenReturn(resourceTypeBeans);
        SyncBeanDef mock = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)"java");
        this.activityBeansCache.addNewEditorActivity(mock, "1", "java");
        List definitions = this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(process);
        Assert.assertTrue((boolean)definitions.isEmpty());
        definitions = this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(model);
        Assert.assertEquals((Object)clientResourceType, definitions.get(0));
    }
}

