/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.client.mvp.LockDemandDetector;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.LockTitleWidgetEvent;
import org.uberfire.client.mvp.RenameInProgressEvent;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Dependent
public class LockManagerImpl
implements LockManager {
    @Inject
    private VFSLockServiceProxy lockService;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleEvent;
    @Inject
    private Event<UpdatedLockStatusEvent> updatedLockStatusEvent;
    @Inject
    private Event<NotificationEvent> lockNotification;
    @Inject
    private LockDemandDetector lockDemandDetector;
    @Inject
    private User user;
    private LockTarget lockTarget;
    private LockInfo lockInfo = LockInfo.unlocked();
    private HandlerRegistration closeHandler;
    private boolean lockRequestPending;
    private boolean unlockRequestPending;
    private boolean lockSyncComplete;
    private List<Runnable> syncCompleteRunnables = new ArrayList<Runnable>();
    private Timer reloadTimer;

    @Override
    public void init(LockTarget lockTarget) {
        this.lockTarget = lockTarget;
        ParameterizedCommand<LockInfo> command = new ParameterizedCommand<LockInfo>(){

            public void execute(LockInfo lockInfo) {
                if (!LockManagerImpl.this.lockRequestPending && !LockManagerImpl.this.unlockRequestPending) {
                    LockManagerImpl.this.updateLockInfo(lockInfo);
                }
            }
        };
        this.lockService.retrieveLockInfo(lockTarget.getPath(), command);
    }

    @Override
    public void onFocus() {
        this.publishJsApi();
        this.fireChangeTitleEvent();
        this.fireUpdatedLockStatusEvent();
    }

    @Override
    public void acquireLockOnDemand() {
        if (this.lockTarget == null) {
            return;
        }
        Widget widget = this.getLockTargetWidget();
        com.google.gwt.user.client.Element element = widget.getElement();
        this.acquireLockOnDemand((Element)element);
        widget.addAttachHandler(new AttachEvent.Handler((Element)element){
            final /* synthetic */ Element val$element;
            {
                this.val$element = element;
            }

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    LockManagerImpl.this.acquireLockOnDemand(this.val$element);
                }
            }
        });
    }

    public EventListener acquireLockOnDemand(Element element) {
        com.google.gwt.user.client.Event.sinkEvents((Element)element, (int)this.lockDemandDetector.getLockDemandEventTypes());
        EventListener lockDemandListener = new EventListener(){

            public void onBrowserEvent(com.google.gwt.user.client.Event event) {
                if (LockManagerImpl.this.isLockedByCurrentUser()) {
                    return;
                }
                if (LockManagerImpl.this.lockDemandDetector.isLockRequired(event)) {
                    LockManagerImpl.this.acquireLock();
                }
            }
        };
        com.google.gwt.user.client.Event.setEventListener((Element)element, (EventListener)lockDemandListener);
        return lockDemandListener;
    }

    @Override
    public void acquireLock() {
        if (this.lockTarget == null) {
            return;
        }
        if (this.isLockedByCurrentUser()) {
            this.fireChangeTitleEvent();
            return;
        }
        if (this.lockInfo.isLocked()) {
            this.handleLockFailure(this.lockInfo);
        } else if (!this.lockRequestPending) {
            this.lockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    if (result.isSuccess()) {
                        LockManagerImpl.this.updateLockInfo(result.getLockInfo());
                        LockManagerImpl.this.releaseLockOnClose();
                    } else {
                        LockManagerImpl.this.handleLockFailure(result.getLockInfo());
                    }
                    LockManagerImpl.this.lockRequestPending = false;
                }
            };
            this.lockService.acquireLock(this.lockTarget.getPath(), command);
        }
    }

    @Override
    public void releaseLock() {
        Runnable releaseLock = new Runnable(){

            @Override
            public void run() {
                LockManagerImpl.this.releaseLockInternal();
            }
        };
        if (this.lockSyncComplete) {
            releaseLock.run();
        } else {
            this.syncCompleteRunnables.add(releaseLock);
        }
    }

    private void releaseLockInternal() {
        if (this.isLockedByCurrentUser() && !this.unlockRequestPending) {
            this.unlockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    LockManagerImpl.this.updateLockInfo(result.getLockInfo());
                    if (result.isSuccess() && LockManagerImpl.this.closeHandler != null) {
                        LockManagerImpl.this.closeHandler.removeHandler();
                    }
                    LockManagerImpl.this.unlockRequestPending = false;
                }
            };
            this.lockService.releaseLock(this.lockTarget.getPath(), command);
        }
    }

    private void releaseLockOnClose() {
        this.closeHandler = Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                LockManagerImpl.this.releaseLock();
            }
        });
    }

    private void handleLockFailure(LockInfo lockInfo) {
        if (lockInfo != null) {
            this.updateLockInfo(lockInfo);
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockedMessage(lockInfo.lockedBy()), NotificationEvent.NotificationType.INFO, true, this.lockTarget.getPlace(), Integer.valueOf(20)));
        } else {
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockError(), NotificationEvent.NotificationType.ERROR, true, this.lockTarget.getPlace(), Integer.valueOf(20)));
        }
        if (this.reloadTimer == null) {
            this.reloadTimer = new Timer(){

                public void run() {
                    LockManagerImpl.this.reload();
                }
            };
        }
        if (!this.reloadTimer.isRunning()) {
            this.reloadTimer.schedule(250);
        }
    }

    private void reload() {
        this.lockTarget.getReloadRunnable().run();
    }

    private boolean isLockedByCurrentUser() {
        return this.lockInfo.isLocked() && this.lockInfo.lockedBy().equals(this.user.getIdentifier());
    }

    void updateLockInfo(@Observes LockInfo lockInfo) {
        if (this.getLockTarget() != null && lockInfo.getFile().toURI().equals(this.lockTarget.getPath().toURI())) {
            this.lockInfo = lockInfo;
            this.lockSyncComplete = true;
            this.fireChangeTitleEvent();
            this.fireUpdatedLockStatusEvent();
            for (Runnable runnable : this.getSyncCompleteRunnables()) {
                runnable.run();
            }
            this.getSyncCompleteRunnables().clear();
        }
    }

    public LockTarget getLockTarget() {
        return this.lockTarget;
    }

    boolean isLockSyncComplete() {
        return this.lockSyncComplete;
    }

    List<Runnable> getSyncCompleteRunnables() {
        return this.syncCompleteRunnables;
    }

    void onResourceAdded(@Observes ResourceAddedEvent res) {
        if (this.lockTarget != null && res.getPath().equals(this.lockTarget.getPath())) {
            this.releaseLock();
        }
    }

    void onResourceUpdated(@Observes ResourceUpdatedEvent res) {
        if (this.lockTarget != null && res.getPath().equals(this.lockTarget.getPath())) {
            if (!res.getSessionInfo().getIdentity().equals(this.user)) {
                this.reload();
            }
            this.releaseLock();
        }
    }

    void onSaveInProgress(@Observes SaveInProgressEvent evt) {
        if (this.lockTarget != null && evt.getPath().equals(this.lockTarget.getPath())) {
            this.releaseLock();
        }
    }

    void onRenameInProgress(@Observes RenameInProgressEvent event) {
        if (this.getLockTarget() != null && event.getPath().equals(this.lockTarget.getPath())) {
            this.releaseLock();
        }
    }

    void onLockRequired(@Observes LockRequiredEvent event) {
        if (this.lockTarget != null && this.isVisible() && !this.isLockedByCurrentUser()) {
            this.acquireLock();
        }
    }

    private native void publishJsApi();

    private Widget getLockTargetWidget() {
        IsWidget isWidget = this.lockTarget.getWidget();
        if (isWidget instanceof Widget) {
            return (Widget)isWidget;
        }
        return isWidget.asWidget();
    }

    private boolean isLocked() {
        return this.lockInfo.isLocked();
    }

    protected LockInfo getLockInfo() {
        return this.lockInfo;
    }

    protected void fireChangeTitleEvent() {
        this.changeTitleEvent.fire((Object)LockTitleWidgetEvent.create(this.lockTarget, this.lockInfo, this.user));
    }

    protected void fireUpdatedLockStatusEvent() {
        if (this.isVisible()) {
            this.updatedLockStatusEvent.fire((Object)new UpdatedLockStatusEvent(this.lockInfo.getFile(), this.lockInfo.isLocked(), this.isLockedByCurrentUser()));
        }
    }

    private boolean isVisible() {
        Widget widget = this.getLockTargetWidget();
        com.google.gwt.user.client.Element element = widget.getElement();
        boolean visible = UIObject.isVisible((Element)element) && element.getAbsoluteLeft() != 0 && element.getAbsoluteTop() != 0;
        return visible;
    }
}

