/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuUtils;
import org.uberfire.client.workbench.widgets.menu.base.WorkbenchBaseMenuView;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.CanBeDisabled;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.HasChildren;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.Selectable;
import org.uberfire.client.workbench.widgets.menu.megamenu.brand.MegaMenuBrand;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.visitor.WorkbenchMegaMenuContextMenuVisitor;
import org.uberfire.client.workbench.widgets.menu.megamenu.visitor.WorkbenchMegaMenuVisitor;
import org.uberfire.mvp.Command;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class WorkbenchMegaMenuPresenter
extends WorkbenchBaseMenuPresenter {
    private AuthorizationManager authzManager;
    private PerspectiveManager perspectiveManager;
    private ActivityManager activityManager;
    private User identity;
    private View view;
    private ManagedInstance<MegaMenuBrand> megaMenuBrands;
    private PlaceManager placeManager;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    private Workbench workbench;
    Map<String, Selectable> selectableMenuItemByIdentifier = new HashMap<String, Selectable>();
    Map<String, HasChildren> hasChildrenMenuItemByIdentifier = new HashMap<String, HasChildren>();
    Map<String, CanBeDisabled> canBeDisabledMenuItemByIdentifier = new HashMap<String, CanBeDisabled>();

    public WorkbenchMegaMenuPresenter(AuthorizationManager authzManager, PerspectiveManager perspectiveManager, ActivityManager activityManager, User identity, View view, ManagedInstance<MegaMenuBrand> megaMenuBrands, PlaceManager placeManager, AuthorizationManager authorizationManager, SessionInfo sessionInfo, ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters, ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters, ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters, ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters, Workbench workbench) {
        this.authzManager = authzManager;
        this.perspectiveManager = perspectiveManager;
        this.activityManager = activityManager;
        this.identity = identity;
        this.view = view;
        this.megaMenuBrands = megaMenuBrands;
        this.placeManager = placeManager;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.childMenuItemPresenters = childMenuItemPresenters;
        this.groupMenuItemPresenters = groupMenuItemPresenters;
        this.childContextMenuItemPresenters = childContextMenuItemPresenters;
        this.groupContextMenuItemPresenters = groupContextMenuItemPresenters;
        this.workbench = workbench;
        this.setup();
    }

    void setup() {
        this.view.init(this);
        this.setupBrand();
        this.setupHomeLink();
    }

    public IsElement getView() {
        return this.view;
    }

    @Override
    protected WorkbenchBaseMenuView getBaseView() {
        return this.view;
    }

    @Override
    protected void visitMenus(Menus addedMenu) {
        addedMenu.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new WorkbenchMegaMenuVisitor(this, this.perspectiveManager, this.placeManager){

            @Override
            public void visit(MenuCustom<?> menuCustom) {
                Object build = menuCustom.build();
                if (build instanceof IsElement) {
                    WorkbenchMegaMenuPresenter.this.addCustomMenuItem((IsElement)build, menuCustom.getPosition());
                } else if (build instanceof IsWidget) {
                    WorkbenchMegaMenuPresenter.this.addCustomMenuItem((IsWidget)((IsWidget)build).asWidget(), menuCustom.getPosition());
                } else {
                    WorkbenchMegaMenuPresenter.this.addMenuItem(WorkbenchBaseMenuUtils.getMenuItemId(menuCustom), menuCustom.getCaption(), this.getParentId(), null, menuCustom.getPosition());
                }
                this.setupEnableDisableMenuItem((MenuItem)menuCustom);
            }
        }));
        this.synchronizeUIWithMenus(addedMenu.getItems());
    }

    public void clear() {
        this.view.clear();
    }

    public void addMenuItem(String id, String label, String parentId, Command command, MenuPosition position) {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)this.childMenuItemPresenters.get();
        childMenuItemPresenter.setup(label, command);
        this.selectableMenuItemByIdentifier.put(id, childMenuItemPresenter);
        this.canBeDisabledMenuItemByIdentifier.put(id, childMenuItemPresenter);
        if (parentId == null || parentId.isEmpty()) {
            if (MenuPosition.RIGHT.equals((Object)position)) {
                this.view.addMenuItemOnRight(childMenuItemPresenter);
            } else {
                this.view.addMenuItemOnLeft(childMenuItemPresenter);
            }
        } else {
            this.view.addMenuItemOnParent(childMenuItemPresenter, this.hasChildrenMenuItemByIdentifier.get(parentId));
        }
    }

    public void addCustomMenuItem(IsElement menu, MenuPosition position) {
        this.view.addCustomMenuItem(menu);
    }

    public void addCustomMenuItem(IsWidget menu, MenuPosition position) {
        this.view.addCustomMenuItem(menu);
    }

    public void addGroupMenuItem(String id, String label, MenuPosition position) {
        GroupMenuItemPresenter groupMenuItemPresenter = (GroupMenuItemPresenter)this.groupMenuItemPresenters.get();
        groupMenuItemPresenter.setup(label);
        this.hasChildrenMenuItemByIdentifier.put(id, groupMenuItemPresenter);
        this.view.addGroupMenuItem(groupMenuItemPresenter);
    }

    public void selectMenuItem(String id) {
        Selectable itemPresenter = this.selectableMenuItemByIdentifier.get(id);
        if (itemPresenter != null) {
            itemPresenter.select();
        }
    }

    public void addContextMenuItem(String menuItemId, String id, String label, String parentId, Command command, MenuPosition position) {
        ChildContextMenuItemPresenter childContextMenuItemPresenter = (ChildContextMenuItemPresenter)this.childContextMenuItemPresenters.get();
        childContextMenuItemPresenter.setup(label, command);
        this.selectableMenuItemByIdentifier.put(id, childContextMenuItemPresenter);
        this.canBeDisabledMenuItemByIdentifier.put(id, childContextMenuItemPresenter);
        if (parentId == null || parentId.isEmpty()) {
            if (MenuPosition.RIGHT.equals((Object)position)) {
                childContextMenuItemPresenter.pullRight();
            }
            this.view.addContextMenuItem(childContextMenuItemPresenter);
        } else {
            this.view.addContextMenuItemOnParent(childContextMenuItemPresenter, this.hasChildrenMenuItemByIdentifier.get(parentId));
        }
        this.view.setContextMenuActive(true);
    }

    public void addContextGroupMenuItem(String menuItemId, String id, String label, MenuPosition position) {
        GroupContextMenuItemPresenter groupContextMenuItemPresenter = (GroupContextMenuItemPresenter)this.groupContextMenuItemPresenters.get();
        groupContextMenuItemPresenter.setup(label);
        this.hasChildrenMenuItemByIdentifier.put(id, groupContextMenuItemPresenter);
        this.canBeDisabledMenuItemByIdentifier.put(id, groupContextMenuItemPresenter);
        if (MenuPosition.RIGHT.equals((Object)position)) {
            groupContextMenuItemPresenter.pullRight();
        }
        this.view.addContextMenuItem(groupContextMenuItemPresenter);
        this.view.setContextMenuActive(true);
    }

    public void clearContextMenu() {
        this.view.clearContextMenu();
    }

    public void enableMenuItem(String menuItemId, boolean enabled) {
        CanBeDisabled menuItem = this.canBeDisabledMenuItemByIdentifier.get(menuItemId);
        if (menuItem != null) {
            if (enabled) {
                menuItem.enable();
            } else {
                menuItem.disable();
            }
        }
    }

    public void enableContextMenuItem(String menuItemId, boolean enabled) {
        this.enableMenuItem(menuItemId, enabled);
    }

    protected void addPerspectiveMenus(PerspectiveActivity perspective) {
        String perspectiveId = perspective.getIdentifier();
        Menus menus = perspective.getMenus();
        this.view.clearContextMenu();
        if (menus != null) {
            menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.identity, (MenuVisitor)new WorkbenchMegaMenuContextMenuVisitor(this, this.placeManager, perspectiveId)));
            this.synchronizeUIWithMenus(menus.getItems());
        }
    }

    protected void onPerspectiveChange(PerspectiveChange perspectiveChange) {
        Activity activity = this.activityManager.getActivity(perspectiveChange.getPlaceRequest());
        if (activity != null && activity.isType(ActivityResourceType.PERSPECTIVE.name())) {
            this.addPerspectiveMenus((PerspectiveActivity)activity);
        }
        this.selectMenuItem(perspectiveChange.getPlaceRequest().getIdentifier());
    }

    private void setupBrand() {
        String defaultMenuText = this.view.getDefaultMenuText();
        if (this.megaMenuBrands.isAmbiguous()) {
            throw new RuntimeException("Multiple implementations of MegaMenuBrand were provided.");
        }
        if (!this.megaMenuBrands.isUnsatisfied()) {
            MegaMenuBrand megaMenuBrand = (MegaMenuBrand)this.megaMenuBrands.get();
            String brandImageUrl = megaMenuBrand.brandImageUrl();
            if (brandImageUrl != null && !brandImageUrl.isEmpty()) {
                this.view.setBrandImage(brandImageUrl);
                String brandImageLabel = megaMenuBrand.brandImageLabel();
                if (brandImageLabel != null && !brandImageLabel.isEmpty()) {
                    this.view.setBrandImageTitle(brandImageLabel);
                }
            } else {
                this.view.hideBrand();
            }
            String menuAccessorLabel = megaMenuBrand.menuAccessorLabel();
            if (menuAccessorLabel != null && !menuAccessorLabel.isEmpty()) {
                this.view.setMenuAccessorText(menuAccessorLabel);
            } else {
                this.view.setMenuAccessorText(defaultMenuText);
            }
        } else {
            this.view.hideBrand();
            this.view.setMenuAccessorText(defaultMenuText);
        }
    }

    void setupHomeLink() {
        this.view.setHomeLinkAction(() -> this.goToHomePerspective());
        this.view.setBrandImageAction(() -> this.goToHomePerspective());
    }

    private void goToHomePerspective() {
        String homePerspectiveIdentifier;
        PerspectiveActivity homePerspectiveActivity = this.workbench.getHomePerspectiveActivity();
        if (homePerspectiveActivity != null && this.hasAccessToPerspective(homePerspectiveIdentifier = homePerspectiveActivity.getIdentifier())) {
            this.placeManager.goTo(homePerspectiveIdentifier);
        }
    }

    boolean hasAccessToPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.sessionInfo.getIdentity());
    }

    public static interface View
    extends WorkbenchBaseMenuView,
    UberElement<WorkbenchMegaMenuPresenter>,
    IsElement {
        @Override
        public void clear();

        public void clearContextMenu();

        public void setHomeLinkAction(Command var1);

        public void setBrandImageAction(Command var1);

        public String getDefaultMenuText();

        public void setBrandImage(String var1);

        public void setBrandImageTitle(String var1);

        public void hideBrand();

        public void setMenuAccessorText(String var1);

        public void addMenuItemOnRight(ChildMenuItemPresenter var1);

        public void addMenuItemOnLeft(ChildMenuItemPresenter var1);

        public void addMenuItemOnParent(ChildMenuItemPresenter var1, HasChildren var2);

        public void addCustomMenuItem(IsElement var1);

        public void addCustomMenuItem(IsWidget var1);

        public void addGroupMenuItem(GroupMenuItemPresenter var1);

        public void addContextMenuItem(GroupContextMenuItemPresenter var1);

        public void addContextMenuItem(ChildContextMenuItemPresenter var1);

        public void addContextMenuItemOnParent(ChildContextMenuItemPresenter var1, HasChildren var2);

        public void setContextMenuActive(boolean var1);
    }
}

