/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenterTest;
import org.uberfire.client.workbench.panels.impl.SimpleNoExpandWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleNoExpandWorkbenchPanelPresenterTest
extends AbstractDockingWorkbenchPanelPresenterTest {
    @Mock(name="view")
    protected DockingWorkbenchPanelView<SimpleNoExpandWorkbenchPanelPresenter> view;
    @Mock
    private PlaceManager placeManager;
    @InjectMocks
    SimpleNoExpandWorkbenchPanelPresenter presenter;

    @Before
    public void init() {
        this.presenter.init();
        this.presenter.setDefinition(this.panelPresenterPanelDefinition);
    }

    @Override
    AbstractDockingWorkbenchPanelPresenter<?> getPresenterToTest() {
        return this.presenter;
    }

    @Test
    public void viewInitCalledTest() {
        ((DockingWorkbenchPanelView)Mockito.verify(this.view)).init((Object)this.presenter);
    }

    @Test
    public void addPartTest() {
        WorkbenchPartPresenter workbenchPartPresenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        PartDefinition partDefinition = (PartDefinition)Mockito.mock(PartDefinition.class);
        Mockito.when((Object)workbenchPartPresenter.getDefinition()).thenReturn((Object)partDefinition);
        this.presenter.addPart(workbenchPartPresenter);
        boolean hasPart = this.panelPresenterPanelDefinition.getParts().stream().filter(part -> part.equals(partDefinition)).findFirst().isPresent();
        Assert.assertTrue((boolean)hasPart);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)0))).tryClosePlace((PlaceRequest)Matchers.any(), (Command)Matchers.any());
        Mockito.when((Object)this.view.getParts()).thenReturn(Arrays.asList(partDefinition));
        this.presenter.addPart(workbenchPartPresenter);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).tryClosePlace((PlaceRequest)Matchers.any(), (Command)Matchers.any());
    }
}

