/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityAndMetaInfo;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManagerImpl;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActivityManagerActivatedByTest {
    private final SyncBeanDef<Activity> activatedActivityBean = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
    private final SyncBeanDef<Activity> nonActivatedActivityBean = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
    @InjectMocks
    private ActivityManagerImpl activityManager;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private ResourceTypeManagerCache resourceTypeManagerCache;
    @Mock
    private AuthorizationManager authzManager;
    @Mock
    private ExperimentalActivitiesAuthorizationManager activitiesAuthorizationManager;
    private Activity activatedActivity;

    @Before
    public void setup() {
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.any(User.class))).thenReturn((Object)true);
        Mockito.when((Object)this.activitiesAuthorizationManager.authorizeActivity(Mockito.anyObject())).thenReturn((Object)true);
        this.activatedActivity = (Activity)Mockito.mock(Activity.class);
        Mockito.when((Object)this.activatedActivity.getIdentifier()).thenReturn((Object)"activated activity");
        Mockito.when((Object)this.activatedActivityBean.getInstance()).thenReturn((Object)this.activatedActivity);
        Mockito.when((Object)this.activatedActivityBean.isActivated()).thenReturn((Object)true);
        Mockito.when((Object)this.nonActivatedActivityBean.isActivated()).thenReturn((Object)false);
        ArrayList<SyncBeanDef<Activity>> activityList = new ArrayList<SyncBeanDef<Activity>>();
        activityList.add(this.activatedActivityBean);
        activityList.add(this.nonActivatedActivityBean);
        Mockito.when((Object)this.iocManager.lookupBeans(Activity.class)).thenReturn(activityList);
        ActivityAndMetaInfo activatedActivityAndMetaInfo = new ActivityAndMetaInfo(this.iocManager, this.activatedActivityBean, 0, Collections.emptyList());
        Mockito.when((Object)this.resourceTypeManagerCache.getResourceActivities()).thenReturn(Collections.singletonList(activatedActivityAndMetaInfo));
        Mockito.when((Object)this.activityBeansCache.getActivity("activated activity")).thenReturn(this.activatedActivityBean);
    }

    @After
    public void runBlanketVerifications() {
        ((SyncBeanDef)Mockito.verify(this.nonActivatedActivityBean, (VerificationMode)Mockito.never())).getInstance();
        ((SyncBeanDef)Mockito.verify(this.nonActivatedActivityBean, (VerificationMode)Mockito.never())).newInstance();
    }

    @Test
    public void getActivitiesByTypeShouldRespectBeanActivationStatus() throws Exception {
        Set activities = this.activityManager.getActivities(Activity.class);
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertSame((Object)this.activatedActivity, activities.iterator().next());
    }

    @Test
    public void getActivitiesForActivePlaceRequestShouldReturnActivity() throws Exception {
        Set activities = this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest("activated activity"));
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertSame((Object)this.activatedActivity, activities.iterator().next());
    }

    @Test
    public void getActivitiesForInactivePlaceRequestShouldReturnEmptySet() throws Exception {
        Set activities = this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest("non-activated activity"));
        Assert.assertEquals((long)0L, (long)activities.size());
    }

    @Test
    public void getActivityForActivePlaceRequestShouldReturnActivity() throws Exception {
        Activity activity = this.activityManager.getActivity(Activity.class, (PlaceRequest)new DefaultPlaceRequest("activated activity"));
        Assert.assertSame((Object)this.activatedActivity, (Object)activity);
    }

    @Test
    public void getActivityForInactivePlaceRequestShouldReturnNull() throws Exception {
        Activity activity = this.activityManager.getActivity(Activity.class, (PlaceRequest)new DefaultPlaceRequest("non-activated activity"));
        Assert.assertNull((Object)activity);
    }
}

