/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import junit.framework.TestCase;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.mvp.BookmarkableUrlHelper;
import org.uberfire.client.util.MockIOCBeanDef;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class BookmarkableUrlHelperTest
extends TestCase {
    @BeforeClass
    public static void setupBeans() {
        ((SyncBeanManagerImpl)IOC.getBeanManager()).reset();
        IOC.getBeanManager().registerBean(new MockIOCBeanDef<ObservablePath, ObservablePathImpl>(new ObservablePathImpl(), ObservablePath.class, Dependent.class, new HashSet<Annotation>(Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS)), null, true, new Class[0]));
    }

    @Test
    public void testRegisterOpen() {
        DefaultPlaceRequest req1 = new DefaultPlaceRequest("screen1");
        DefaultPlaceRequest req2 = new DefaultPlaceRequest("screen2");
        DefaultPlaceRequest req3 = new DefaultPlaceRequest("screen3");
        DefaultPlaceRequest req4 = new DefaultPlaceRequest("screen4");
        String perspective = "perspective";
        String url = "";
        url = BookmarkableUrlHelper.registerOpenedScreen((String)url, (PlaceRequest)req1);
        BookmarkableUrlHelperTest.assertEquals((String)req1.getFullIdentifier(), (String)url);
        url = BookmarkableUrlHelper.registerOpenedScreen((String)url, (PlaceRequest)req2);
        BookmarkableUrlHelperTest.assertEquals((String)"screen1,screen2", (String)url);
        url = "perspective".concat("|").concat(url);
        url = BookmarkableUrlHelper.registerOpenedScreen((String)url, (PlaceRequest)req3);
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1,screen2$screen3", (String)url);
        url = BookmarkableUrlHelper.registerOpenedScreen((String)url, (PlaceRequest)req4);
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1,screen2$screen3,screen4", (String)url);
        String closedScreen = "closedScreen";
        DefaultPlaceRequest closed = new DefaultPlaceRequest("closedScreen");
        url = "perspective|".concat("~").concat("closedScreen").concat(",openScreen$externalScreen");
        url = BookmarkableUrlHelper.registerOpenedScreen((String)url, (PlaceRequest)closed);
        String expected = "perspective|".concat("closedScreen").concat(",openScreen$externalScreen");
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
        StringBuilder bigUrl = new StringBuilder("perspective");
        while (bigUrl.length() < 1900) {
            bigUrl.append(",screen");
        }
        url = BookmarkableUrlHelper.registerOpenedScreen((String)bigUrl.toString(), (PlaceRequest)req1);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertEquals((String)bigUrl.toString(), (String)url);
    }

    @Test
    public void testRegisterClose() {
        String url = "perspective|screen1,screen2$screen3,screen4";
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen3");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1,screen2$screen4", (String)url);
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen4");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1,screen2", (String)url);
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen1");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|~screen1,screen2", (String)url);
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen2");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|~screen1,~screen2", (String)url);
        url = "perspective|screen1,~screen2$screen3";
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen2");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1,~screen2$screen3", (String)url);
        url = "perspective|screen1$screen2";
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen2");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1", (String)url);
        url = "perspective|screen1$screen2,screen3";
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen2");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1$screen3", (String)url);
        url = "perspective|screen1$screen2,screen3,screen4";
        url = BookmarkableUrlHelper.registerClose((String)url, (String)"screen3");
        BookmarkableUrlHelperTest.assertEquals((String)"perspective|screen1$screen2,screen4", (String)url);
    }

    @Test
    public void testGetPerspectiveFromPlace() {
        String perspectiveName = "eccePerspective";
        String bookmarkableUrl = "eccePerspective".concat("|~screen1,~screen2");
        DefaultPlaceRequest req = new DefaultPlaceRequest(bookmarkableUrl);
        PlaceRequest place = BookmarkableUrlHelper.getPerspectiveFromPlace((PlaceRequest)req);
        BookmarkableUrlHelperTest.assertNotNull((Object)place);
        BookmarkableUrlHelperTest.assertNotSame((Object)req, (Object)place);
        BookmarkableUrlHelperTest.assertEquals((String)"eccePerspective", (String)place.getFullIdentifier());
        DefaultPlaceRequest empty = new DefaultPlaceRequest("screenOpened,~screenClosed");
        empty.addParameter("param", "value");
        place = BookmarkableUrlHelper.getPerspectiveFromPlace((PlaceRequest)empty);
        BookmarkableUrlHelperTest.assertNotNull((Object)place);
        BookmarkableUrlHelperTest.assertEquals((String)empty.getFullIdentifier(), (String)place.getFullIdentifier());
    }

    @Test
    public void testGetPerspectiveFromPlaceWithParams() {
        String perspectiveName = "eccePerspective";
        String bookmarkableUrl = "eccePerspective".concat("|~screen1,~screen2");
        DefaultPlaceRequest req = new DefaultPlaceRequest(bookmarkableUrl);
        req.addParameter("param", "value");
        PlaceRequest place = BookmarkableUrlHelper.getPerspectiveFromPlace((PlaceRequest)req);
        BookmarkableUrlHelperTest.assertNotNull((Object)place);
        BookmarkableUrlHelperTest.assertNotSame((Object)req, (Object)place);
        StringBuilder expected = new StringBuilder("eccePerspective");
        expected.append("?param=value");
        BookmarkableUrlHelperTest.assertEquals((String)expected.toString(), (String)place.getFullIdentifier());
    }

    @Test
    public void testIsPerspectiveScreen() {
        String url = "perspective|screen1,screen2$screen3,screen4";
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4", (String)"screen1"));
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4", (String)"screen2"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4", (String)"screen3"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4", (String)"screen4"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveScreen(null, (String)"screen2"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"", (String)"screen2"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4", null));
    }

    @Test
    public void testIsPerspectiveInUrl() {
        String url1 = "perspective|screen1,screen2$screen3,screen4";
        String url2 = "screen1,screen2";
        String url3 = "perspective|screen1,screen2$screen3,screen4";
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isPerspectiveInUrl((String)"perspective|screen1,screen2$screen3,screen4"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isPerspectiveInUrl((String)"screen1,screen2"));
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isPerspectiveInUrl((String)"perspective|screen1,screen2$screen3,screen4"));
    }

    @Test
    public void testUrlContainsExtraPerspectiveScreen() {
        String url1 = "perspective|screen1,screen2$screen3,screen4";
        String url2 = "screen1,screen2";
        String url3 = "perspective|screen1,screen2$screen3,screen4";
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.urlContainsExtraPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.urlContainsExtraPerspectiveScreen((String)"screen1,screen2"));
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.urlContainsExtraPerspectiveScreen((String)"perspective|screen1,screen2$screen3,screen4"));
    }

    @Test
    public void testGetUrlInToken() {
        String url1 = "perspective|#screen1,\u00a7screen2$#screen3,!screen4";
        String url2 = "!screen1,#screen2";
        BookmarkableUrlHelperTest.assertEquals((String)"!screen1", (String)BookmarkableUrlHelper.getUrlToken((String)"!screen1,#screen2", (String)"screen1"));
        BookmarkableUrlHelperTest.assertEquals((String)"#screen2", (String)BookmarkableUrlHelper.getUrlToken((String)"!screen1,#screen2", (String)"screen2"));
        BookmarkableUrlHelperTest.assertEquals((String)"\u00a7screen2", (String)BookmarkableUrlHelper.getUrlToken((String)"perspective|#screen1,\u00a7screen2$#screen3,!screen4", (String)"screen2"));
        BookmarkableUrlHelperTest.assertEquals((String)"#screen1", (String)BookmarkableUrlHelper.getUrlToken((String)"perspective|#screen1,\u00a7screen2$#screen3,!screen4", (String)"screen1"));
        BookmarkableUrlHelperTest.assertEquals((String)"#screen3", (String)BookmarkableUrlHelper.getUrlToken((String)"perspective|#screen1,\u00a7screen2$#screen3,!screen4", (String)"screen3"));
        BookmarkableUrlHelperTest.assertEquals((String)"!screen4", (String)BookmarkableUrlHelper.getUrlToken((String)"perspective|#screen1,\u00a7screen2$#screen3,!screen4", (String)"screen4"));
    }

    @Test
    public void testGetScreensFromPlace() {
        String url = "perspective|~screen1,screen2$!screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        String url3 = "PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        DefaultPlaceRequest place = new DefaultPlaceRequest("perspective|~screen1,screen2$!screen3,screen4");
        DefaultPlaceRequest place2 = new DefaultPlaceRequest("UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]");
        DefaultPlaceRequest placeNoPerspective = new DefaultPlaceRequest("PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]");
        PlaceRequest placeNull = null;
        Set set = BookmarkableUrlHelper.getScreensFromPlace((PlaceRequest)place);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertEquals((int)4, (int)set.size());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("~screen1"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("screen2"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("!screen3"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("screen4"));
        set = BookmarkableUrlHelper.getScreensFromPlace((PlaceRequest)place2);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertEquals((int)1, (int)set.size());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("PagedTableScreen"));
        set = BookmarkableUrlHelper.getScreensFromPlace(placeNull);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
        set = BookmarkableUrlHelper.getScreensFromPlace((PlaceRequest)placeNoPerspective);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("PagedTableScreen"));
    }

    @Test
    public void testGetClosedScreenFromPlace() {
        String url = "perspective|~screen1,screen2$~screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        DefaultPlaceRequest place = new DefaultPlaceRequest("perspective|~screen1,screen2$~screen3,screen4");
        DefaultPlaceRequest place2 = new DefaultPlaceRequest("UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]");
        Set set = BookmarkableUrlHelper.getClosedScreenFromPlace((PlaceRequest)place);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertEquals((int)2, (int)set.size());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("~screen1"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("~screen3"));
        set = BookmarkableUrlHelper.getClosedScreenFromPlace((PlaceRequest)place2);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testGetOpenedScreenFromPlace() {
        String url = "perspective|~screen1,screen2$~screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        DefaultPlaceRequest place = new DefaultPlaceRequest("perspective|~screen1,screen2$~screen3,screen4");
        DefaultPlaceRequest place2 = new DefaultPlaceRequest("UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]");
        Set set = BookmarkableUrlHelper.getOpenedScreenFromPlace((PlaceRequest)place);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("screen2"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("screen4"));
        set = BookmarkableUrlHelper.getOpenedScreenFromPlace((PlaceRequest)place2);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("PagedTableScreen"));
    }

    @Test
    public void testGDockedScreensFromPlace() {
        String url = "perspective|~screen1,screen2$~screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        DefaultPlaceRequest place = new DefaultPlaceRequest("perspective|~screen1,screen2$~screen3,screen4");
        DefaultPlaceRequest place2 = new DefaultPlaceRequest("UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]");
        Set set = BookmarkableUrlHelper.getDockedScreensFromPlace((PlaceRequest)place);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
        set = BookmarkableUrlHelper.getDockedScreensFromPlace((PlaceRequest)place2);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertEquals((int)2, (int)set.size());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("ESimpleDockScreen"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("!WSimpleDockScreen"));
        set = BookmarkableUrlHelper.getDockedScreensFromPlace(null);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testGDockedScreensFromPlaceString() {
        String url = "perspective|~screen1,screen2$~screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,EAnotherDockScreen,]";
        Set set = BookmarkableUrlHelper.getDockedScreensFromUrl((String)"perspective|~screen1,screen2$~screen3,screen4");
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
        set = BookmarkableUrlHelper.getDockedScreensFromUrl((String)"UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,EAnotherDockScreen,]");
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertFalse((boolean)set.isEmpty());
        BookmarkableUrlHelperTest.assertEquals((int)3, (int)set.size());
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("ESimpleDockScreen"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("!WSimpleDockScreen"));
        BookmarkableUrlHelperTest.assertTrue((boolean)set.contains("EAnotherDockScreen"));
        set = BookmarkableUrlHelper.getDockedScreensFromUrl(null);
        BookmarkableUrlHelperTest.assertNotNull((Object)set);
        BookmarkableUrlHelperTest.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testIsScreenClosed() {
        String url = "perspective|~screen1,screen2$~screen3,screen4";
        String url2 = "UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]";
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isScreenClosed((String)"perspective|~screen1,screen2$~screen3,screen4", (String)"screen1"));
        BookmarkableUrlHelperTest.assertTrue((boolean)BookmarkableUrlHelper.isScreenClosed((String)"perspective|~screen1,screen2$~screen3,screen4", (String)"screen3"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"perspective|~screen1,screen2$~screen3,screen4", (String)"screen2"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"perspective|~screen1,screen2$~screen3,screen4", (String)"screen4"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]", (String)"PagedTableScreen"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]", (String)"ESimpleDockScreen"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]", (String)"ESimpleDockScreen"));
        BookmarkableUrlHelperTest.assertFalse((boolean)BookmarkableUrlHelper.isScreenClosed((String)"UFWidgets|PagedTableScreen[ESimpleDockScreen,!WSimpleDockScreen,ESimpleDockScreen,]", (String)"!WSimpleDockScreen"));
    }

    @Test
    public void testRegisterOpenedPerspective() {
        String screens = "screen1,~screen2";
        String perspective = "perspective";
        DefaultPlaceRequest place = new DefaultPlaceRequest("perspective");
        String url = "screen1,~screen2";
        url = BookmarkableUrlHelper.registerOpenedPerspective((String)url, (PlaceRequest)place);
        BookmarkableUrlHelperTest.assertEquals((String)"perspective".concat("|").concat("screen1,~screen2"), (String)url);
    }

    @Test
    public void testRegisterOpenDock() {
        String screens = "screen1";
        String dockName = "dockedScreen";
        String perspectiveName = "perspectiveName";
        String url = "perspectiveName".concat("|").concat("screen1");
        UberfireDock dock1 = this.createUberfireDockForTest("dockedScreen", "perspectiveName");
        UberfireDock dock2 = this.createUberfireDockForTest("dockedScreen".concat("New"), "perspectiveName");
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertEquals((String)"perspectiveName".concat("|").concat("screen1[WdockedScreen,]"), (String)url);
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock2);
        BookmarkableUrlHelperTest.assertEquals((String)"perspectiveName".concat("|").concat("screen1[WdockedScreen,WdockedScreenNew,]"), (String)url);
        url = "perspectiveName".concat("|").concat("screen1[!WdockedScreen,]");
        String expected = "perspectiveName".concat("|").concat("screen1[WdockedScreen,]");
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
        expected = BookmarkableUrlHelper.registerOpenedDock((String)url, null);
        BookmarkableUrlHelperTest.assertNotNull((Object)expected);
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
        url = "  ";
        expected = BookmarkableUrlHelper.registerOpenedDock((String)url, null);
        BookmarkableUrlHelperTest.assertNotNull((Object)expected);
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
    }

    @Test
    public void testDoubleRegisterOpenDock() {
        String screens = "screen1";
        String dockName = "dockedScreen";
        String perspectiveName = "perspectiveName";
        String url = "perspectiveName".concat("|").concat("screen1");
        UberfireDock dock1 = this.createUberfireDockForTest("dockedScreen", "perspectiveName");
        UberfireDock dock2 = this.createUberfireDockForTest("dockedScreen".concat("New"), "perspectiveName");
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock1);
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertEquals((String)"perspectiveName".concat("|").concat("screen1[WdockedScreen,]"), (String)url);
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock2);
        url = BookmarkableUrlHelper.registerOpenedDock((String)url, (UberfireDock)dock2);
        BookmarkableUrlHelperTest.assertEquals((String)"perspectiveName".concat("|").concat("screen1[WdockedScreen,WdockedScreenNew,]"), (String)url);
    }

    @Test
    public void testRegisterClosedDock() {
        String dockName1 = "dockedScreen1";
        String dockName2 = "dockedScreen2";
        String perspectiveName = "perspective";
        String url = "perspectiveName|screen[WdockedScreen1,WdockedScreen2,]";
        UberfireDock dock1 = this.createUberfireDockForTest("dockedScreen1", perspectiveName);
        UberfireDock dock2 = this.createUberfireDockForTest("dockedScreen2", perspectiveName);
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertTrue((boolean)url.contains("!WdockedScreen1"));
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock2);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertTrue((boolean)url.contains("!WdockedScreen2"));
    }

    @Test
    public void testDoubleRegisterClosedDock() {
        String dockName1 = "dockedScreen1";
        String dockName2 = "dockedScreen2";
        String perspectiveName = "perspective";
        String url = "perspectiveName|screen[WdockedScreen1,WdockedScreen2,]";
        UberfireDock dock1 = this.createUberfireDockForTest("dockedScreen1", perspectiveName);
        UberfireDock dock2 = this.createUberfireDockForTest("dockedScreen2", perspectiveName);
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock1);
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertTrue((boolean)url.contains("!WdockedScreen1"));
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock2);
        url = BookmarkableUrlHelper.registerClosedDock((String)url, (UberfireDock)dock2);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertTrue((boolean)url.contains("!WdockedScreen2"));
        String expected = "anyBookmarkableUrl";
        url = BookmarkableUrlHelper.registerClosedDock((String)expected, null);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
        expected = "    ";
        url = BookmarkableUrlHelper.registerClosedDock((String)expected, (UberfireDock)dock2);
        BookmarkableUrlHelperTest.assertNotNull((Object)url);
        BookmarkableUrlHelperTest.assertEquals((String)expected, (String)url);
    }

    @Test
    public void testOpenADockWithEmptyBookmark() {
        UberfireDock dock1 = this.createUberfireDockForTest("dock", "perspective");
        String url = BookmarkableUrlHelper.registerOpenedDock((String)"", (UberfireDock)dock1);
        BookmarkableUrlHelperTest.assertEquals((String)"[Wdock,]", (String)url);
    }

    @Test
    public void testRegisterCloseEditor() {
        Path path = PathFactory.newPath((String)"file", (String)"default://master@repo/path/to/file");
        PathPlaceRequest ppr = new PathPlaceRequest(path);
        ppr.setIdentifier("Perspective Editor");
        String perspectiveClosedUrl = "PlugInAuthoringPerspective|[WPlugins Explorer,]$";
        String perspectiveOpenUrl = "PlugInAuthoringPerspective|[WPlugins Explorer,]$".concat(ppr.getFullIdentifier());
        String url = BookmarkableUrlHelper.registerCloseEditor((String)perspectiveOpenUrl, (PlaceRequest)ppr);
        BookmarkableUrlHelperTest.assertEquals((String)"PlugInAuthoringPerspective|[WPlugins Explorer,]$", (String)url);
        DefaultPlaceRequest dpr = new DefaultPlaceRequest("default://master@repo/path/to/file");
        url = BookmarkableUrlHelper.registerCloseEditor((String)perspectiveOpenUrl, (PlaceRequest)dpr);
        BookmarkableUrlHelperTest.assertEquals((String)perspectiveOpenUrl, (String)url);
    }

    @Test
    public void testRegisterCloseEditorWithScreens() {
        Path path = PathFactory.newPath((String)"file", (String)"default://master@repo/path/to/file");
        PathPlaceRequest ppr = new PathPlaceRequest(path);
        ppr.setIdentifier("Perspective Editor");
        String perspectiveClosedUrl = "PlugInAuthoringPerspective|[WPlugins Explorer,]$";
        String perspectiveOpenUrl = "PlugInAuthoringPerspective|[WPlugins Explorer,]$".concat(ppr.getFullIdentifier()).concat(",screen1");
        String url = BookmarkableUrlHelper.registerCloseEditor((String)perspectiveOpenUrl, (PlaceRequest)ppr);
        String expectedUrl = "PlugInAuthoringPerspective|[WPlugins Explorer,]$screen1";
        BookmarkableUrlHelperTest.assertEquals((String)"PlugInAuthoringPerspective|[WPlugins Explorer,]$screen1", (String)url);
        url = BookmarkableUrlHelper.registerCloseEditor((String)"PlugInAuthoringPerspective|[WPlugins Explorer,]$screen1", null);
        BookmarkableUrlHelperTest.assertEquals((String)"PlugInAuthoringPerspective|[WPlugins Explorer,]$screen1", (String)url);
    }

    private UberfireDock createUberfireDockForTest(String dockName, String perspectiveName) {
        DefaultPlaceRequest req = new DefaultPlaceRequest(dockName);
        UberfireDock dock = new UberfireDock(UberfireDockPosition.WEST, "iconType", (PlaceRequest)req, perspectiveName);
        return dock;
    }
}

