/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import java.util.function.Consumer;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarStandalonePresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMenuBarStandalonePresenterTest {
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    protected User identity;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private WorkbenchMenuBarPresenter.View view;
    @InjectMocks
    private WorkbenchMenuBarStandalonePresenter presenter;

    @Test
    public void testAddMenus() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager, (VerificationMode)Mockito.never())).authorize((Resource)Matchers.any(MenuItem.class), (User)Matchers.any(User.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenus() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)"perspectiveId");
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgumentAt(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)Matchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem(Matchers.anyString(), (String)Matchers.eq((Object)"contextLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.isNull(Command.class), (MenuPosition)Matchers.eq((Object)MenuPosition.LEFT));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).clearContextMenu();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addContextMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }
}

