/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.VFSServiceProxy;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.WorkbenchCustomStandalonePerspectiveDefinition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchStandaloneModeTest {
    @Mock
    private VFSServiceProxy vfsService;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ManagedInstance<WorkbenchCustomStandalonePerspectiveDefinition> workbenchCustomStandalonePerspectiveDefinitions;
    @Spy
    @InjectMocks
    private Workbench workbench;

    @Test
    public void handleStandaloneModeWithPerspectiveParameterTest() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("perspective", Collections.singletonList("MyPerspective"));
        this.workbench.handleStandaloneMode(parameters);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest((String)((List)parameters.get("perspective")).get(0)));
    }

    @Test
    public void handleStandaloneModeWithPathParameterAndNoCustomStandaloneEditorPerspectiveDefinitionTest() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.workbenchCustomStandalonePerspectiveDefinitions)).isUnsatisfied();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("path", Collections.singletonList("git://master@MySpace/MyProject/src/main/java/com/myspace/myproject/myasset.java"));
        this.workbench.handleStandaloneMode(parameters);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest("StandaloneEditorPerspective"));
    }

    @Test
    public void handleStandaloneModeWithPathParameterAndCustomStandaloneEditorPerspectiveDefinitionNotOpeningEditorByDefaultTest() {
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.workbenchCustomStandalonePerspectiveDefinitions)).isUnsatisfied();
        WorkbenchCustomStandalonePerspectiveDefinition workbenchCustomStandalonePerspectiveDefinition = (WorkbenchCustomStandalonePerspectiveDefinition)Mockito.mock(WorkbenchCustomStandalonePerspectiveDefinition.class);
        ((WorkbenchCustomStandalonePerspectiveDefinition)Mockito.doReturn((Object)"MyCustomStandalonePerspective").when((Object)workbenchCustomStandalonePerspectiveDefinition)).getStandalonePerspectiveIdentifier();
        ((WorkbenchCustomStandalonePerspectiveDefinition)Mockito.doReturn((Object)false).when((Object)workbenchCustomStandalonePerspectiveDefinition)).openPathAutomatically();
        ((ManagedInstance)Mockito.doReturn((Object)workbenchCustomStandalonePerspectiveDefinition).when(this.workbenchCustomStandalonePerspectiveDefinitions)).get();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("path", Collections.singletonList("git://master@MySpace/MyProject/src/main/java/com/myspace/myproject/myasset.java"));
        this.workbench.handleStandaloneMode(parameters);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest("MyCustomStandalonePerspective"));
        ((VFSServiceProxy)Mockito.verify((Object)this.vfsService, (VerificationMode)Mockito.never())).get((String)Mockito.any(), (ParameterizedCommand)Mockito.any());
    }

    @Test
    public void handleStandaloneModeWithPathParameterAndCustomStandaloneEditorPerspectiveDefinitionOpeningEditorByDefaultTest() {
        ((Workbench)Mockito.doNothing().when((Object)this.workbench)).openEditor((Path)Mockito.any());
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("path", Collections.singletonList("git://master@MySpace/MyProject/src/main/java/com/myspace/myproject/myasset.java"));
        Path path = (Path)Mockito.mock(Path.class);
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.workbenchCustomStandalonePerspectiveDefinitions)).isUnsatisfied();
        WorkbenchCustomStandalonePerspectiveDefinition workbenchCustomStandalonePerspectiveDefinition = (WorkbenchCustomStandalonePerspectiveDefinition)Mockito.mock(WorkbenchCustomStandalonePerspectiveDefinition.class);
        ((WorkbenchCustomStandalonePerspectiveDefinition)Mockito.doReturn((Object)"MyCustomStandalonePerspective").when((Object)workbenchCustomStandalonePerspectiveDefinition)).getStandalonePerspectiveIdentifier();
        ((WorkbenchCustomStandalonePerspectiveDefinition)Mockito.doReturn((Object)true).when((Object)workbenchCustomStandalonePerspectiveDefinition)).openPathAutomatically();
        ((ManagedInstance)Mockito.doReturn((Object)workbenchCustomStandalonePerspectiveDefinition).when(this.workbenchCustomStandalonePerspectiveDefinitions)).get();
        ((VFSServiceProxy)Mockito.doAnswer(invocationOnMock -> {
            ((ParameterizedCommand)invocationOnMock.getArgumentAt(1, ParameterizedCommand.class)).execute((Object)path);
            return null;
        }).when((Object)this.vfsService)).get((String)Mockito.same(((List)parameters.get("path")).get(0)), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        this.workbench.handleStandaloneMode(parameters);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)Mockito.any(PlaceRequest.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)new DefaultPlaceRequest("MyCustomStandalonePerspective"));
        ((VFSServiceProxy)Mockito.verify((Object)this.vfsService)).get((String)Mockito.same(((List)parameters.get("path")).get(0)), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        ((Workbench)Mockito.verify((Object)this.workbench)).openEditor(path);
    }
}

