/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.ioc.client.QualifierUtil;
import org.jboss.errai.ioc.client.container.SyncBeanDef;

public class MockIOCBeanDef<T, B extends T>
implements SyncBeanDef<T> {
    private final B beanInstance;
    private final Class<T> type;
    private final Class<? extends Annotation> scope;
    private final Set<Annotation> qualifiers;
    private final String name;
    private final boolean activated;
    private final Set<Class<?>> assignableTypes = new HashSet();

    public MockIOCBeanDef(B beanInstance, Class<T> type, Class<? extends Annotation> scope, Set<Annotation> qualifiers, String name, boolean activated, Class<?> ... otherTypes) {
        this.beanInstance = beanInstance;
        this.type = type;
        this.scope = scope;
        this.qualifiers = qualifiers;
        this.name = name;
        this.activated = activated;
        this.assignableTypes.add(type);
        this.assignableTypes.addAll(Arrays.asList(otherTypes));
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<?> getBeanClass() {
        return this.beanInstance.getClass();
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public T getInstance() {
        return (T)this.beanInstance;
    }

    public T newInstance() {
        return (T)this.beanInstance;
    }

    public Set<Annotation> getQualifiers() {
        if (this.qualifiers == null) {
            return Collections.emptySet();
        }
        return this.qualifiers;
    }

    public boolean matches(Set<Annotation> annotations) {
        return QualifierUtil.matches(annotations, this.getQualifiers());
    }

    public String getName() {
        return this.name;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isAssignableTo(Class<?> type) {
        return this.assignableTypes.contains(type);
    }
}

