/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManagerImpl;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectiveManagerTest {
    @Mock
    PlaceManager placeManager;
    @Mock
    PanelManager panelManager;
    @Mock
    ActivityManager activityManager;
    @Mock
    WorkbenchServicesProxy wbServices;
    @Mock
    Event<PerspectiveChange> perspectiveChangeEvent;
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    SyncBeanManager iocManager;
    @Spy
    @InjectMocks
    PerspectiveManagerImpl perspectiveManager;
    private PerspectiveDefinition ozDefinition;
    private PerspectiveActivity oz;
    private PlaceRequest pr;
    private ParameterizedCommand<PerspectiveDefinition> doWhenFinished;
    private ParameterizedCommand<PerspectiveDefinition> doAfterFetch;
    private Command doWhenFinishedSave;
    private PerspectiveManagerImpl.FetchPerspectiveCommand fetchCommand;
    private List<PartDefinitionImpl> partDefinitionsRoot;
    private List<PartDefinitionImpl> partDefinitionRootChild1;
    private List<PartDefinitionImpl> partDefinitionRootChild2;
    private List<PartDefinitionImpl> partDefinitionRootChild2Child;

    @Before
    public void setup() {
        this.ozDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        this.oz = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        this.pr = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)this.oz.getDefaultPerspectiveLayout()).thenReturn((Object)this.ozDefinition);
        Mockito.when((Object)this.oz.getIdentifier()).thenReturn((Object)"oz_perspective");
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)true);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgumentAt(0, Consumer.class)).accept(null);
            return null;
        }).when((Object)this.oz)).getMenus((Consumer)Matchers.any());
        this.doWhenFinished = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.doAfterFetch = (ParameterizedCommand)Mockito.spy((Object)new ParameterizedCommand<PerspectiveDefinition>(){

            public void execute(PerspectiveDefinition parameter) {
            }
        });
        this.doWhenFinishedSave = (Command)Mockito.mock(Command.class);
        PerspectiveManagerImpl perspectiveManagerImpl = this.perspectiveManager;
        perspectiveManagerImpl.getClass();
        this.fetchCommand = (PerspectiveManagerImpl.FetchPerspectiveCommand)Mockito.spy((Object)new PerspectiveManagerImpl.FetchPerspectiveCommand(perspectiveManagerImpl, this.pr, this.oz, this.doAfterFetch));
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Command callback = (Command)invocation.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.wbServices)).save((String)Matchers.any(String.class), (PerspectiveDefinition)Matchers.any(PerspectiveDefinition.class), (Command)Matchers.any(Command.class));
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[1];
                callback.execute(null);
                return null;
            }
        }).when((Object)this.wbServices)).loadPerspective(Matchers.anyString(), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
        Mockito.when((Object)this.panelManager.addWorkbenchPanel((PanelDefinition)Matchers.any(PanelDefinition.class), (PanelDefinition)Matchers.any(PanelDefinition.class), (Position)Matchers.any(Position.class))).thenAnswer((Answer)new Answer<PanelDefinition>(){

            public PanelDefinition answer(InvocationOnMock invocation) {
                return (PanelDefinition)invocation.getArguments()[1];
            }
        });
    }

    @Test
    public void shouldReportNullPerspectiveInitially() throws Exception {
        Assert.assertNull((Object)this.perspectiveManager.getCurrentPerspective());
    }

    @Test
    public void shouldReportNewPerspectiveAsCurrentAfterSwitching() throws Exception {
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        Assert.assertSame((Object)this.oz, (Object)this.perspectiveManager.getCurrentPerspective());
    }

    @Test
    public void shouldSaveNonTransientPerspectives() throws Exception {
        PerspectiveDefinitionImpl kansasDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PerspectiveActivity kansas = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)kansas.getDefaultPerspectiveLayout()).thenReturn((Object)kansasDefinition);
        Mockito.when((Object)kansas.getIdentifier()).thenReturn((Object)"kansas_perspective");
        Mockito.when((Object)kansas.isTransient()).thenReturn((Object)false);
        this.perspectiveManager.switchToPerspective(this.pr, kansas, this.doWhenFinished);
        this.perspectiveManager.savePerspectiveState(this.doWhenFinishedSave);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices)).save((String)Matchers.eq((Object)"kansas_perspective"), (PerspectiveDefinition)Matchers.eq((Object)kansasDefinition), (Command)Matchers.eq((Object)this.doWhenFinishedSave));
    }

    @Test
    public void shouldNotSaveTransientPerspectives() throws Exception {
        PerspectiveDefinitionImpl kansasDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PerspectiveActivity kansas = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)kansas.getDefaultPerspectiveLayout()).thenReturn((Object)kansasDefinition);
        Mockito.when((Object)kansas.getIdentifier()).thenReturn((Object)"kansas_perspective");
        Mockito.when((Object)kansas.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(this.pr, kansas, this.doWhenFinished);
        this.perspectiveManager.savePerspectiveState(this.doWhenFinishedSave);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices, (VerificationMode)Mockito.never())).save((String)Matchers.any(String.class), (PerspectiveDefinition)Matchers.eq((Object)kansasDefinition), (Command)Matchers.any(Command.class));
    }

    @Test
    public void shouldLoadNewNonTransientPerspectiveState() throws Exception {
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)false);
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices)).loadPerspective((String)Matchers.eq((Object)"oz_perspective"), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void shouldNotLoadNewTransientPerspectiveState() throws Exception {
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices, (VerificationMode)Mockito.never())).loadPerspective((String)Matchers.eq((Object)"oz_perspective"), (ParameterizedCommand)Matchers.any(ParameterizedCommand.class));
    }

    @Test
    public void shouldExecuteCallbackWhenDoneLaunchingPerspective() throws Exception {
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((ParameterizedCommand)Mockito.verify(this.doWhenFinished)).execute((Object)this.ozDefinition);
    }

    @Test
    public void shouldFireEventWhenLaunchingNewPerspective() throws Exception {
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((Event)Mockito.verify(this.perspectiveChangeEvent)).fire(Matchers.refEq((Object)new PerspectiveChange(this.pr, this.ozDefinition, null, "oz_perspective"), (String[])new String[0]));
    }

    @Test
    public void shouldAddAllPanelsToPanelManager() throws Exception {
        PanelDefinitionImpl westPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl eastPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl northPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl southPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl southWestPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)westPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.EAST, (PanelDefinition)eastPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.NORTH, (PanelDefinition)northPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.SOUTH, (PanelDefinition)southPanel);
        southPanel.appendChild((Position)CompassPosition.WEST, (PanelDefinition)southWestPanel);
        Mockito.when((Object)this.panelManager.getRoot()).thenReturn((Object)this.ozDefinition.getRoot());
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)westPanel, (Position)CompassPosition.WEST);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)eastPanel, (Position)CompassPosition.EAST);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)northPanel, (Position)CompassPosition.NORTH);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)southPanel, (Position)CompassPosition.SOUTH);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel((PanelDefinition)southPanel, (PanelDefinition)southWestPanel, (Position)CompassPosition.WEST);
    }

    @Test
    public void shouldDestroyAllOldPanelsWhenSwitchingRoot() throws Exception {
        PerspectiveDefinitionImpl fooPerspectiveDef = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinition rootPanel = fooPerspectiveDef.getRoot();
        PanelDefinitionImpl fooPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl fooChildPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl barPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl bazPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        rootPanel.appendChild((PanelDefinition)fooPanel);
        rootPanel.appendChild((PanelDefinition)barPanel);
        rootPanel.appendChild((PanelDefinition)bazPanel);
        fooPanel.appendChild((PanelDefinition)fooChildPanel);
        PerspectiveActivity fooPerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)fooPerspective.getDefaultPerspectiveLayout()).thenReturn((Object)fooPerspectiveDef);
        Mockito.when((Object)fooPerspective.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(this.pr, fooPerspective, this.doWhenFinished);
        this.perspectiveManager.switchToPerspective(this.pr, this.oz, this.doWhenFinished);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)fooPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)fooChildPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)barPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)bazPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).removeWorkbenchPanel(rootPanel);
    }

    @Test
    public void fetchPerspectiveCommandForAnInvalidDefinitionShouldLoadedPerspectiveDefinitionTest() throws Exception {
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)false);
        Mockito.when((Object)this.fetchCommand.isAValidDefinition((PerspectiveDefinition)Matchers.any())).thenReturn((Object)false);
        this.fetchCommand.execute();
        Assert.assertEquals((Object)this.oz, (Object)this.perspectiveManager.getCurrentPerspective());
        ((ParameterizedCommand)Mockito.verify(this.doAfterFetch)).execute(Matchers.eq((Object)this.ozDefinition));
    }

    @Test
    public void fetchPerspectivesForTransientPerspectivesShouldAlwaysLoadDefaultLayoutTest() throws Exception {
        Mockito.when((Object)this.fetchCommand.isAValidDefinition((PerspectiveDefinition)Matchers.any())).thenReturn((Object)true);
        this.fetchCommand.execute();
        Assert.assertEquals((Object)this.oz, (Object)this.perspectiveManager.getCurrentPerspective());
        ((ParameterizedCommand)Mockito.verify(this.doAfterFetch)).execute(Matchers.eq((Object)this.ozDefinition));
    }

    @Test
    public void isAValidPerspectiveDefinitionTest() throws Exception {
        this.createPartDefinitions();
        Mockito.when((Object)this.activityBeansCache.hasActivity((String)Matchers.any())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.fetchCommand.isAValidDefinition(this.createPerspectiveDefinition()));
        ((ActivityBeansCache)Mockito.verify((Object)this.activityBeansCache, (VerificationMode)Mockito.times((int)this.getTotalOfPartDefinitions()))).hasActivity((String)Matchers.any());
    }

    @Test
    public void isAnInvalidPerspectiveDefinitionTest() throws Exception {
        Mockito.when((Object)this.activityBeansCache.hasActivity((String)Matchers.any())).thenReturn((Object)true);
        Assert.assertFalse((boolean)this.fetchCommand.isAValidDefinition(null));
    }

    @Test
    public void isAnInvalidPerspectiveDefinition2Test() throws Exception {
        this.createPartDefinitions();
        Mockito.when((Object)this.activityBeansCache.hasActivity((String)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.activityBeansCache.hasActivity("part3-rootChild2")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.fetchCommand.isAValidDefinition(this.createPerspectiveDefinition()));
    }

    @Test
    public void getDefaultPerspectiveIdentifierTest() {
        ArrayList<SyncBeanDef<AbstractWorkbenchPerspectiveActivity>> perspectives = new ArrayList<SyncBeanDef<AbstractWorkbenchPerspectiveActivity>>();
        SyncBeanDef<AbstractWorkbenchPerspectiveActivity> otherPerspectiveBeanDef = this.getPerspectiveBeanDef("otherPerspectiveBeanDef", false);
        SyncBeanDef<AbstractWorkbenchPerspectiveActivity> homePerspectiveBeanDef = this.getPerspectiveBeanDef("homePerspectiveBeanDef", true);
        perspectives.add(otherPerspectiveBeanDef);
        perspectives.add(homePerspectiveBeanDef);
        ((PerspectiveManagerImpl)Mockito.doReturn(perspectives.iterator()).when((Object)this.perspectiveManager)).getPerspectivesIterator();
        String defaultPerspectiveIdentifier = this.perspectiveManager.getDefaultPerspectiveIdentifier();
        Assert.assertEquals((Object)((AbstractWorkbenchPerspectiveActivity)homePerspectiveBeanDef.getInstance()).getIdentifier(), (Object)defaultPerspectiveIdentifier);
        ((SyncBeanManager)Mockito.verify((Object)this.iocManager)).destroyBean(otherPerspectiveBeanDef.getInstance());
        ((SyncBeanManager)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.never())).destroyBean(homePerspectiveBeanDef.getInstance());
    }

    private SyncBeanDef<AbstractWorkbenchPerspectiveActivity> getPerspectiveBeanDef(String identifier, boolean isDefault) {
        AbstractWorkbenchPerspectiveActivity perspectiveActivity = (AbstractWorkbenchPerspectiveActivity)Mockito.mock(AbstractWorkbenchPerspectiveActivity.class);
        ((AbstractWorkbenchPerspectiveActivity)Mockito.doReturn((Object)identifier).when((Object)perspectiveActivity)).getIdentifier();
        ((AbstractWorkbenchPerspectiveActivity)Mockito.doReturn((Object)isDefault).when((Object)perspectiveActivity)).isDefault();
        SyncBeanDef perspectiveBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        ((SyncBeanDef)Mockito.doReturn((Object)perspectiveActivity).when((Object)perspectiveBeanDef)).getInstance();
        return perspectiveBeanDef;
    }

    private PerspectiveDefinition createPerspectiveDefinition() {
        PerspectiveDefinitionImpl perspectiveDefinition = new PerspectiveDefinitionImpl();
        PanelDefinition root = perspectiveDefinition.getRoot();
        this.partDefinitionsRoot.forEach(p -> root.addPart((PartDefinition)p));
        PanelDefinitionImpl rootChild1 = new PanelDefinitionImpl("org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter");
        this.partDefinitionRootChild1.forEach(p -> rootChild1.addPart((PartDefinition)p));
        PanelDefinitionImpl rootChild2 = new PanelDefinitionImpl("org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter");
        this.partDefinitionRootChild2.forEach(p -> rootChild2.addPart((PartDefinition)p));
        PanelDefinitionImpl rootChild2Child = new PanelDefinitionImpl("org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter");
        this.partDefinitionRootChild2Child.forEach(p -> rootChild2Child.addPart((PartDefinition)p));
        root.insertChild((Position)Mockito.mock(Position.class), (PanelDefinition)rootChild1);
        rootChild2.insertChild((Position)Mockito.mock(Position.class), (PanelDefinition)rootChild2Child);
        root.insertChild((Position)Mockito.mock(Position.class), (PanelDefinition)rootChild2);
        return perspectiveDefinition;
    }

    private void createPartDefinitions() {
        this.partDefinitionsRoot = Arrays.asList(new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part1")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part2")));
        this.partDefinitionRootChild1 = Arrays.asList(new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part1-rootChild1")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part2-rootChild1")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part3-rootChild1")));
        this.partDefinitionRootChild2 = Arrays.asList(new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part1-rootChild2")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part2-rootChild2")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part3-rootChild2")));
        this.partDefinitionRootChild2Child = Arrays.asList(new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part1-rootChild2Child")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part2-rootChild2Child")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part3-rootChild2Child")), new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("part4-rootChild2Child")));
    }

    private int getTotalOfPartDefinitions() {
        int total = this.partDefinitionsRoot.size() + this.partDefinitionRootChild1.size() + this.partDefinitionRootChild2.size() + this.partDefinitionRootChild2Child.size();
        return total;
    }
}

