/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.BookmarkableUrlHelper;
import org.uberfire.client.mvp.PlaceHistoryHandler;
import org.uberfire.client.mvp.PlaceRequestHistoryMapper;
import org.uberfire.client.mvp.WorkbenchScreenActivity;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class PlaceHistoryHandlerTest {
    private final WorkbenchScreenActivity screenActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
    private final WorkbenchScreenActivity perspectiveActivity = (WorkbenchScreenActivity)Mockito.mock(WorkbenchScreenActivity.class);
    @Mock
    private PlaceRequestHistoryMapper mapper;
    @Spy
    PlaceHistoryHandler placeHistoryHandler;
    static final String SCREEN1_ID = "screen1";
    static final String SCREEN2_ID = "screen2";
    static final String SCREEN3_ID = "screen3";
    static final String SCREEN4_ID = "screen4";
    static final String PERSPECTIVE_ID = "perspective";

    @Before
    public void setup() {
        Mockito.when((Object)this.screenActivity.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)this.screenActivity.isType(ActivityResourceType.SCREEN.name())).thenReturn((Object)true);
        Mockito.when((Object)this.screenActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)this.screenActivity.preferredWidth()).thenReturn((Object)26);
        Mockito.when((Object)this.screenActivity.preferredHeight()).thenReturn((Object)77);
        Mockito.when((Object)this.perspectiveActivity.isDynamic()).thenReturn((Object)false);
        Mockito.when((Object)this.perspectiveActivity.isDefault()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectiveActivity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.perspectiveActivity.onMayClose()).thenReturn((Object)true);
        Mockito.when((Object)this.perspectiveActivity.preferredWidth()).thenReturn((Object)26);
        Mockito.when((Object)this.perspectiveActivity.preferredHeight()).thenReturn((Object)77);
    }

    @Test
    public void testPerspectiveFromUrlSimple() {
        DefaultPlaceRequest req = new DefaultPlaceRequest(PERSPECTIVE_ID);
        PlaceRequest place = BookmarkableUrlHelper.getPerspectiveFromPlace((PlaceRequest)req);
        Assert.assertNotNull((Object)place);
        Assert.assertEquals((Object)PERSPECTIVE_ID, (Object)place.getIdentifier());
        Assert.assertSame((Object)place, (Object)req);
    }

    @Test
    public void testPerspectiveFromUrlWithHistory() {
        String REQUEST = "perspective|secreenOne,~screenTwo$screenThree";
        DefaultPlaceRequest req = new DefaultPlaceRequest("perspective|secreenOne,~screenTwo$screenThree");
        PlaceRequest place = BookmarkableUrlHelper.getPerspectiveFromPlace((PlaceRequest)req);
        Assert.assertNotNull((Object)place);
        Assert.assertEquals((Object)PERSPECTIVE_ID, (Object)place.getIdentifier());
        Assert.assertNotSame((Object)place, (Object)req);
    }

    @Test
    public void testRegisterExistingURL() {
        String REQUEST = "perspective|secreenOne,~screenTwo$screenThree";
        DefaultPlaceRequest req = new DefaultPlaceRequest("perspective|secreenOne,~screenTwo$screenThree");
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)req);
        Assert.assertEquals((Object)"perspective|secreenOne,~screenTwo$screenThree", (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testRegisterBuild() {
        String SCREEN1_ID = SCREEN1_ID;
        String SCREEN2_ID = SCREEN2_ID;
        String PERSPECTIVE_ID = PERSPECTIVE_ID;
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        DefaultPlaceRequest perspective = new DefaultPlaceRequest(PERSPECTIVE_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)SCREEN1_ID, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String SCREENS_OPEN_LIST = SCREEN1_ID.concat(",").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)SCREENS_OPEN_LIST, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String PERSPECTIVE_STRING = PERSPECTIVE_ID.concat("|").concat(SCREENS_OPEN_LIST);
        this.placeHistoryHandler.registerOpen((Activity)this.perspectiveActivity, (PlaceRequest)perspective);
        Assert.assertEquals((Object)PERSPECTIVE_STRING, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void TestScreenCloseSimple() {
        String SCREEN1_ID = SCREEN1_ID;
        String SCREEN2_ID = SCREEN2_ID;
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)SCREEN1_ID, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String CLOSED_SCREENS = "~".concat(SCREEN1_ID);
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)CLOSED_SCREENS, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String URL2 = "~".concat(SCREEN1_ID).concat(",").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)URL2, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        URL2 = "~".concat(SCREEN1_ID).concat(",~").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)URL2, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void TestScreenCloseSimpleWithArgs() {
        String SCREEN1_ID = SCREEN1_ID;
        String SCREEN2_ID = SCREEN2_ID;
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        String PAR1_KEY = "y";
        String PAR1_VALUE = "x";
        String PAR2_KEY = "a";
        String PAR2_VALUE = "b";
        String PARAM_TAIL = this.getParamListForTest("a", "b", "y", "x");
        screen1.addParameter("y", "x");
        screen1.addParameter("a", "b");
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)SCREEN1_ID.concat(PARAM_TAIL), (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String CLOSED_SCREENS = "~".concat(SCREEN1_ID).concat(PARAM_TAIL);
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)CLOSED_SCREENS, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String URL2 = "~".concat(SCREEN1_ID).concat(PARAM_TAIL).concat(",").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)URL2, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        URL2 = "~".concat(SCREEN1_ID).concat(PARAM_TAIL).concat(",~").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)URL2, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testOtherScreen() {
        String SCREEN1_ID = SCREEN1_ID;
        String SCREEN2_ID = SCREEN2_ID;
        String SCREEN3_ID = SCREEN3_ID;
        String PERSPECTIVE_ID = PERSPECTIVE_ID;
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        DefaultPlaceRequest screen3 = new DefaultPlaceRequest(SCREEN3_ID);
        DefaultPlaceRequest perspective = new DefaultPlaceRequest(PERSPECTIVE_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)SCREEN1_ID, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String PERSPECTIVE_STRING = PERSPECTIVE_ID.concat("|").concat(SCREEN1_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.perspectiveActivity, (PlaceRequest)perspective);
        Assert.assertEquals((Object)PERSPECTIVE_STRING, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        String EXPECTED_URL = PERSPECTIVE_STRING.concat("$").concat(SCREEN2_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        EXPECTED_URL = EXPECTED_URL.concat(",").concat(SCREEN3_ID);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen3);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testCloseAllScreens() {
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        DefaultPlaceRequest screen3 = new DefaultPlaceRequest(SCREEN3_ID);
        DefaultPlaceRequest screen4 = new DefaultPlaceRequest(SCREEN4_ID);
        this.prepareCompleteUrlWithParamsForTests();
        String EXPECTED_URL = "perspective|screen1,~screen2$screen3?y=x,screen4?y=x";
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen2);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        EXPECTED_URL = "perspective|screen1,~screen2$screen4?y=x";
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen3);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        EXPECTED_URL = "perspective|screen1,~screen2";
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen4);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        EXPECTED_URL = "perspective|~screen1,~screen2";
        this.placeHistoryHandler.registerClose((Activity)this.screenActivity, (PlaceRequest)screen1);
        Assert.assertEquals((Object)EXPECTED_URL, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void TestFlush() {
        this.prepareCompleteUrlForTests();
        this.placeHistoryHandler.flush();
        Assert.assertNotNull((Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        Assert.assertEquals((Object)"", (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testRegisterOpenDock() {
        String dockName = "testDock";
        String placeRequestName = "testPlacerequest";
        DefaultPlaceRequest place = new DefaultPlaceRequest("testPlacerequest");
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)place);
        DefaultPlaceRequest dockPlace = new DefaultPlaceRequest("testDock");
        UberfireDocksInteractionEvent openEvent = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        UberfireDock dock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)dock.getDockPosition()).thenReturn((Object)UberfireDockPosition.WEST);
        Mockito.when((Object)dock.getIdentifier()).thenReturn((Object)"testDock");
        Mockito.when((Object)dock.getIconType()).thenReturn((Object)"iconType");
        Mockito.when((Object)dock.getPlaceRequest()).thenReturn((Object)dockPlace);
        Mockito.when((Object)openEvent.getType()).thenReturn((Object)UberfireDocksInteractionEvent.InteractionType.OPENED);
        Mockito.when((Object)openEvent.getTargetDock()).thenReturn((Object)dock);
        this.placeHistoryHandler.registerOpenDock(openEvent);
        StringBuilder expected = new StringBuilder("testPlacerequest");
        expected.append("[");
        expected.append("W");
        expected.append("testDock");
        expected.append(",");
        expected.append("]");
        Assert.assertEquals((Object)expected.toString(), (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testRegisterCloseDock() {
        String dockName = "testDock";
        String placeRequestName = "testPlacerequest";
        DefaultPlaceRequest place = new DefaultPlaceRequest("testPlacerequest");
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)place);
        DefaultPlaceRequest dockPlace = new DefaultPlaceRequest("testDock");
        UberfireDocksInteractionEvent openEvent = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        UberfireDocksInteractionEvent closeEvent = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        UberfireDock dock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)dock.getDockPosition()).thenReturn((Object)UberfireDockPosition.WEST);
        Mockito.when((Object)dock.getIdentifier()).thenReturn((Object)"testDock");
        Mockito.when((Object)dock.getIconType()).thenReturn((Object)"iconType");
        Mockito.when((Object)dock.getPlaceRequest()).thenReturn((Object)dockPlace);
        Mockito.when((Object)openEvent.getType()).thenReturn((Object)UberfireDocksInteractionEvent.InteractionType.OPENED);
        Mockito.when((Object)openEvent.getTargetDock()).thenReturn((Object)dock);
        Mockito.when((Object)closeEvent.getType()).thenReturn((Object)UberfireDocksInteractionEvent.InteractionType.CLOSED);
        Mockito.when((Object)closeEvent.getTargetDock()).thenReturn((Object)dock);
        this.placeHistoryHandler.registerOpenDock(openEvent);
        this.placeHistoryHandler.registerCloseDock(closeEvent);
        StringBuilder expected = new StringBuilder("testPlacerequest");
        expected.append("[");
        expected.append("!");
        expected.append("W");
        expected.append("testDock");
        expected.append(",");
        expected.append("]");
        Assert.assertEquals((Object)expected.toString(), (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    @Test
    public void testUrlLimit() {
        int cnt = 0;
        int length = 0;
        do {
            DefaultPlaceRequest screen = new DefaultPlaceRequest("screen".concat(String.valueOf(cnt++)));
            this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen);
            if (length == this.placeHistoryHandler.getCurrentBookmarkableURLStatus().length()) break;
            length = this.placeHistoryHandler.getCurrentBookmarkableURLStatus().length();
        } while (this.placeHistoryHandler.getCurrentBookmarkableURLStatus().length() < 2000);
        Assert.assertNotNull((Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
        Assert.assertFalse((this.placeHistoryHandler.getCurrentBookmarkableURLStatus().length() > 1900 ? 1 : 0) != 0);
    }

    @Test
    public void testGetOpenScreens() {
        String url = "perspective|screen1,!screen2,~screen3$!screen4";
        DefaultPlaceRequest req = new DefaultPlaceRequest("perspective|screen1,!screen2,~screen3$!screen4");
        Set opened = BookmarkableUrlHelper.getOpenedScreenFromPlace((PlaceRequest)req);
        Assert.assertNotNull((Object)opened);
        Assert.assertEquals((long)3L, (long)opened.size());
        Assert.assertTrue((boolean)opened.contains(SCREEN1_ID));
        Assert.assertTrue((boolean)opened.contains("!screen2"));
        Assert.assertTrue((boolean)opened.contains("!screen4"));
    }

    @Test
    public void testGetClosedScreens() {
        String url = "perspective|screen1,~!screen2,~screen3$~!screen4";
        DefaultPlaceRequest req = new DefaultPlaceRequest("perspective|screen1,~!screen2,~screen3$~!screen4");
        Set closed = BookmarkableUrlHelper.getClosedScreenFromPlace((PlaceRequest)req);
        Assert.assertNotNull((Object)closed);
        Assert.assertEquals((long)3L, (long)closed.size());
        Assert.assertTrue((boolean)closed.contains("~screen3"));
        Assert.assertTrue((boolean)closed.contains("~!screen2"));
        Assert.assertTrue((boolean)closed.contains("~!screen4"));
    }

    private void prepareCompleteUrlForTests() {
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        DefaultPlaceRequest screen3 = new DefaultPlaceRequest(SCREEN3_ID);
        DefaultPlaceRequest screen4 = new DefaultPlaceRequest(SCREEN4_ID);
        DefaultPlaceRequest perspective = new DefaultPlaceRequest(PERSPECTIVE_ID);
        String expectedUrl = "perspective|screen1,screen2$screen3,screen4";
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        this.placeHistoryHandler.registerOpen((Activity)this.perspectiveActivity, (PlaceRequest)perspective);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen3);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen4);
        Assert.assertEquals((Object)"perspective|screen1,screen2$screen3,screen4", (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    private void prepareCompleteUrlWithParamsForTests() {
        DefaultPlaceRequest screen1 = new DefaultPlaceRequest(SCREEN1_ID);
        DefaultPlaceRequest screen2 = new DefaultPlaceRequest(SCREEN2_ID);
        DefaultPlaceRequest screen3 = new DefaultPlaceRequest(SCREEN3_ID);
        DefaultPlaceRequest screen4 = new DefaultPlaceRequest(SCREEN4_ID);
        DefaultPlaceRequest perspective = new DefaultPlaceRequest(PERSPECTIVE_ID);
        String PAR_KEY = "y";
        String PAR_VALUE = "x";
        String PARAM_TAIL = this.getParamListForTest("y", "x");
        String expectedUrl = "perspective|screen1,screen2$screen3" + PARAM_TAIL + ",screen4" + PARAM_TAIL;
        screen3.addParameter("y", "x");
        screen4.addParameter("y", "x");
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen1);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen2);
        this.placeHistoryHandler.registerOpen((Activity)this.perspectiveActivity, (PlaceRequest)perspective);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen3);
        this.placeHistoryHandler.registerOpen((Activity)this.screenActivity, (PlaceRequest)screen4);
        Assert.assertEquals((Object)expectedUrl, (Object)this.placeHistoryHandler.getCurrentBookmarkableURLStatus());
    }

    private String getParamListForTest(String ... txt) {
        boolean isQM = true;
        StringBuilder param = new StringBuilder();
        for (int i = 0; i < txt.length; ++i) {
            if (i == 0 || i % 2 == 0) {
                if (isQM) {
                    param.append("?");
                    isQM = false;
                } else {
                    param.append("&");
                }
                param.append(txt[i]);
                continue;
            }
            param.append("=");
            param.append(txt[i]);
        }
        return param.toString();
    }
}

