/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ContextActivity;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenterTest;
import org.uberfire.client.workbench.panels.impl.AbstractMultiPartWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.ContextDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.ContextDefinitionImpl;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

public abstract class AbstractMultiPartWorkbenchPanelPresenterTest
extends AbstractDockingWorkbenchPanelPresenterTest {
    @Mock(name="view")
    protected DockingWorkbenchPanelView<MultiListWorkbenchPanelPresenter> view;

    abstract AbstractMultiPartWorkbenchPanelPresenter<?> getPresenterToTest();

    @Test
    public void knownContextualPartsShouldResolveToTheirOwnContext() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        ContextActivity myContextActivity = (ContextActivity)Mockito.mock(ContextActivity.class);
        Mockito.when((Object)this.mockActivityManager.getActivity(ContextActivity.class, (PlaceRequest)new DefaultPlaceRequest("myContextId"))).thenReturn((Object)myContextActivity);
        presenter.addPart(this.mockPartPresenter, "myContextId");
        ContextActivity resolvedContextActivity = presenter.resolveContext(this.partPresenterPartDefinition);
        Assert.assertSame((Object)myContextActivity, (Object)resolvedContextActivity);
    }

    @Test
    public void unknownPartsShouldResolveToPerspectiveContext() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        ContextActivity resolvedPerspectiveContextActivity = presenter.resolveContext((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("randomUnknownPlace")));
        Assert.assertSame((Object)this.perspectiveContextActivity, (Object)resolvedPerspectiveContextActivity);
    }

    @Test
    public void unknownPartsShouldResolveToPanelContextWhenThereIsOne() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        ContextDefinitionImpl panelContextDefinition = new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("panelDefinition"));
        ContextActivity panelContextActivity = (ContextActivity)Mockito.mock(ContextActivity.class);
        Mockito.when((Object)this.mockActivityManager.getActivity(ContextActivity.class, (PlaceRequest)new DefaultPlaceRequest("panelDefinition"))).thenReturn((Object)panelContextActivity);
        this.panelPresenterPanelDefinition.setContextDefinition((ContextDefinition)panelContextDefinition);
        presenter.setDefinition(this.panelPresenterPanelDefinition);
        ContextActivity resolvedContextActivity = presenter.resolveContext((PartDefinition)new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("randomUnknownPlace")));
        Assert.assertSame((Object)panelContextActivity, (Object)resolvedContextActivity);
    }

    @Test
    public void presenterShouldFreeRemovedParts() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        ContextActivity fakeContextActivity = (ContextActivity)Mockito.mock(ContextActivity.class);
        Mockito.when((Object)this.mockActivityManager.getActivity((Class)Matchers.eq(ContextActivity.class), (PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn((Object)fakeContextActivity);
        presenter.addPart(this.mockPartPresenter, "randomContextId");
        presenter.removePart(this.mockPartPresenter.getDefinition());
        Assert.assertSame((Object)this.perspectiveContextActivity, (Object)presenter.resolveContext(this.mockPartView.getPresenter().getDefinition()));
    }

    @Test
    public void addedChildPanelsShouldBeRemembered() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        PanelDefinitionImpl childPanelDef = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        Mockito.when((Object)childPanelPresenter.getDefinition()).thenReturn((Object)childPanelDef);
        WorkbenchPanelView childPanelView = (WorkbenchPanelView)Mockito.mock(WorkbenchPanelView.class);
        Mockito.when((Object)childPanelView.getPresenter()).thenReturn((Object)childPanelPresenter);
        presenter.addPanel(childPanelPresenter, (Position)CompassPosition.NORTH);
        Assert.assertSame((Object)childPanelPresenter, presenter.getPanels().get(CompassPosition.NORTH));
        Assert.assertEquals((Object)childPanelDef, (Object)presenter.getDefinition().getChild((Position)CompassPosition.NORTH));
    }

    @Test
    public void removedChildPanelsShouldBeForgotten() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        PanelDefinitionImpl childPanelDef = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        Mockito.when((Object)childPanelPresenter.getDefinition()).thenReturn((Object)childPanelDef);
        WorkbenchPanelView childPanelView = (WorkbenchPanelView)Mockito.mock(WorkbenchPanelView.class);
        Mockito.when((Object)childPanelView.getPresenter()).thenReturn((Object)childPanelPresenter);
        presenter.addPanel(childPanelPresenter, (Position)CompassPosition.NORTH);
        boolean removed = presenter.removePanel(childPanelPresenter);
        Assert.assertTrue((boolean)removed);
        Assert.assertNull(presenter.getPanels().get(CompassPosition.NORTH));
        Assert.assertNull((Object)presenter.getDefinition().getChild((Position)CompassPosition.NORTH));
    }

    @Test
    public void addingChildPanelShouldUpdateParentPointers() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        PanelDefinitionImpl childPanelDef = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        Mockito.when((Object)childPanelPresenter.getDefinition()).thenReturn((Object)childPanelDef);
        WorkbenchPanelView childPanelView = (WorkbenchPanelView)Mockito.mock(WorkbenchPanelView.class);
        Mockito.when((Object)childPanelView.getPresenter()).thenReturn((Object)childPanelPresenter);
        presenter.addPanel(childPanelPresenter, (Position)CompassPosition.NORTH);
        ((WorkbenchPanelPresenter)Mockito.verify((Object)childPanelPresenter)).setParent(presenter);
        Assert.assertSame((Object)presenter.getDefinition(), (Object)childPanelDef.getParent());
    }

    @Test
    public void removingChildPanelShouldClearParentPointers() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        PanelDefinitionImpl childPanelDef = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        WorkbenchPanelView childPanelView = (WorkbenchPanelView)Mockito.mock(WorkbenchPanelView.class);
        Mockito.when((Object)childPanelView.getPresenter()).thenReturn((Object)childPanelPresenter);
        presenter.addPanel(childPanelPresenter, (Position)CompassPosition.NORTH);
        presenter.removePanel(childPanelPresenter);
        ((WorkbenchPanelPresenter)Mockito.verify((Object)childPanelPresenter)).setParent(null);
        Assert.assertNull((Object)childPanelDef.getParent());
    }

    @Test
    public void removingUnknownPanelShouldReturnFalse() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        boolean removed = presenter.removePanel(childPanelPresenter);
        Assert.assertFalse((boolean)removed);
    }

    @Test
    public void removingUnknownPanelShouldNotAffectExistingOnes() throws Exception {
        AbstractMultiPartWorkbenchPanelPresenter<?> presenter = this.getPresenterToTest();
        PanelDefinitionImpl childPanelDef = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        WorkbenchPanelPresenter childPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        Mockito.when((Object)childPanelPresenter.getDefinition()).thenReturn((Object)childPanelDef);
        WorkbenchPanelView childPanelView = (WorkbenchPanelView)Mockito.mock(WorkbenchPanelView.class);
        Mockito.when((Object)childPanelView.getPresenter()).thenReturn((Object)childPanelPresenter);
        WorkbenchPanelPresenter unknownPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        presenter.addPanel(childPanelPresenter, (Position)CompassPosition.NORTH);
        boolean removed = presenter.removePanel(unknownPanelPresenter);
        Assert.assertFalse((boolean)removed);
        Assert.assertSame((Object)childPanelPresenter, presenter.getPanels().get(CompassPosition.NORTH));
        Assert.assertEquals((Object)childPanelDef, (Object)presenter.getDefinition().getChild((Position)CompassPosition.NORTH));
        ((WorkbenchPanelPresenter)Mockito.verify((Object)childPanelPresenter, (VerificationMode)Mockito.never())).setParent(null);
    }
}

