/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuProducer;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuStandalonePresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.brand.MegaMenuBrand;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMegaMenuProducerTest {
    @Mock
    private AuthorizationManager authzManager;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private User identity;
    @Mock
    private WorkbenchMegaMenuPresenter.View view;
    @Mock
    private WorkbenchMegaMenuPresenter defaultPresenter;
    @Mock
    private WorkbenchMegaMenuStandalonePresenter standalonePresenter;
    @Mock
    private PerspectiveChange perspectiveChangeEvent;
    @Mock
    private PlaceMaximizedEvent placeMaximizedEvent;
    @Mock
    private PlaceMinimizedEvent placeMinimizedEvent;
    @Mock
    private ManagedInstance<MegaMenuBrand> megaMenuBrands;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    @Mock
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    @Mock
    private Workbench workbench;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    private WorkbenchMegaMenuProducer producer;
    private boolean isStandalone = false;

    @Before
    public void setup() {
        this.producer = new WorkbenchMegaMenuProducer(this.authzManager, this.perspectiveManager, this.activityManager, this.identity, this.view, this.megaMenuBrands, this.placeManager, this.authorizationManager, this.sessionInfo, this.childMenuItemPresenters, this.groupMenuItemPresenters, this.childContextMenuItemPresenters, this.groupContextMenuItemPresenters, this.workbench, this.experimentalActivitiesAuthorizationManager){

            protected boolean isStandalone() {
                return WorkbenchMegaMenuProducerTest.this.isStandalone;
            }

            protected WorkbenchMegaMenuPresenter makeDefaultPresenter() {
                return WorkbenchMegaMenuProducerTest.this.defaultPresenter;
            }

            protected WorkbenchMegaMenuStandalonePresenter makeStandalonePresenter() {
                return WorkbenchMegaMenuProducerTest.this.standalonePresenter;
            }
        };
    }

    @Test
    public void megaMenuPresenterInstantiationDefaultMode() {
        this.assertMegaMenuPresenter(false, WorkbenchMegaMenuPresenter.class);
    }

    @Test
    public void megaMenuPresenterInstantiationStandaloneMode() {
        this.assertMegaMenuPresenter(true, WorkbenchMegaMenuStandalonePresenter.class);
    }

    @Test
    public void checkObservedEventsCallsPresenterDefaultMode() {
        WorkbenchMegaMenuPresenter presenter = this.getMegaMenuPresenter(false);
        this.assertMegaMenuEvents(presenter);
    }

    @Test
    public void checkObservedEventsCallsPresenterStandaloneMode() {
        WorkbenchMegaMenuPresenter presenter = this.getMegaMenuPresenter(true);
        this.assertMegaMenuEvents(presenter);
    }

    @Test
    public void testNotifyVisibilityChange() {
        this.testNotifyVisibilityChange(false);
    }

    @Test
    public void testNotifyVisibilityChangeStandaloneMode() {
        this.testNotifyVisibilityChange(true);
    }

    private void testNotifyVisibilityChange(boolean isStandalone) {
        WorkbenchMegaMenuPresenter presenter = this.getMegaMenuPresenter(isStandalone);
        presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent("perspectiveId", false));
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)presenter)).onPerspectiveVisibilityChange((PerspectiveVisibiltiyChangeEvent)Matchers.any());
    }

    private void assertMegaMenuPresenter(boolean isStandalone, Class expectedPresenterType) {
        WorkbenchMegaMenuPresenter presenter = this.getMegaMenuPresenter(isStandalone);
        Assert.assertEquals((Object)this.extractContainingClassName(expectedPresenterType.getName()), (Object)this.extractContainingClassName(presenter.getClass().getName()));
    }

    private void assertMegaMenuEvents(WorkbenchMegaMenuPresenter presenter) {
        presenter.onPerspectiveChange(this.perspectiveChangeEvent);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)presenter)).onPerspectiveChange((PerspectiveChange)Matchers.eq((Object)this.perspectiveChangeEvent));
    }

    private WorkbenchMegaMenuPresenter getMegaMenuPresenter(boolean isStandalone) {
        this.isStandalone = isStandalone;
        return (WorkbenchMegaMenuPresenter)this.producer.getWorbenchMenu();
    }

    private String extractContainingClassName(String className) {
        if (className.contains("$$")) {
            return className.substring(0, className.indexOf("$$"));
        }
        return className;
    }
}

