/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManagerImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityManagerImpl;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.util.MockIOCBeanDef;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityManagerLifecycleTest {
    public static final String PATH_PLACE_ID = "id";
    @Mock
    SyncBeanManagerImpl iocManager;
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    AuthorizationManager authzManager;
    @Mock
    private ExperimentalActivitiesAuthorizationManager activitiesAuthorizationManager;
    @Spy
    User dorothy = new UserImpl("dorothy");
    @InjectMocks
    ActivityManagerImpl activityManager = new ActivityManagerImpl();
    PlaceRequest kansas;
    Activity kansasActivity = (Activity)Mockito.mock(Activity.class);
    Path path = (Path)Mockito.mock(Path.class);
    PlaceRequest pathPlace;
    Activity pathPlaceActivity = (Activity)Mockito.mock(Activity.class);
    private SyncBeanDef<Activity> pathIocBeanSpy;

    @Before
    public void setup() {
        this.kansas = new DefaultPlaceRequest("kansas");
        Mockito.when((Object)this.kansasActivity.getPlace()).thenReturn((Object)this.kansas);
        SyncBeanDef<Activity> kansasIocBean = this.makeDependentBean(Activity.class, this.kansasActivity);
        Mockito.when((Object)this.activityBeansCache.getActivity("kansas")).thenReturn(kansasIocBean);
        this.pathPlace = new PathPlaceRequest(this.path){

            protected ObservablePath createObservablePath(Path path) {
                return (ObservablePath)Mockito.mock(ObservablePath.class);
            }
        };
        Mockito.when((Object)this.pathPlaceActivity.getPlace()).thenReturn((Object)this.pathPlace);
        Mockito.when((Object)this.pathPlaceActivity.getIdentifier()).thenReturn((Object)PATH_PLACE_ID);
        SyncBeanDef<Activity> pathIocBean = this.makeDependentBean(Activity.class, this.pathPlaceActivity);
        this.pathIocBeanSpy = (SyncBeanDef)Mockito.spy(pathIocBean);
        Mockito.when((Object)this.activityBeansCache.getActivity(this.pathPlace.getIdentifier())).thenReturn(this.pathIocBeanSpy);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.dorothy))).thenReturn((Object)true);
        Mockito.when((Object)this.activitiesAuthorizationManager.authorizeActivity(Mockito.anyObject())).thenReturn((Object)true);
    }

    @Test
    public void shouldCallOnStartupBeforeReturningNewActivity() throws Exception {
        Set activities = this.activityManager.getActivities(this.kansas);
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertEquals((Object)this.kansasActivity, activities.iterator().next());
        ((Activity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.times((int)1))).onStartup(this.kansas);
    }

    @Test
    public void shouldResolvePlaceIdentifierForPathPlaceRequestOnGetActivity() throws Exception {
        Assert.assertEquals((Object)PathPlaceRequest.NULL, (Object)this.pathPlace.getIdentifier());
        Activity activity = this.activityManager.getActivity(this.pathPlace);
        Assert.assertNotNull((Object)activity);
        Assert.assertEquals((Object)PATH_PLACE_ID, (Object)this.pathPlace.getIdentifier());
        Assert.assertEquals((Object)this.pathPlaceActivity, (Object)activity);
    }

    @Test
    public void shouldResolvePlaceIdentifierForPathPlaceRequestsOnGetActivities() throws Exception {
        Assert.assertEquals((Object)PathPlaceRequest.NULL, (Object)this.pathPlace.getIdentifier());
        Set activities = this.activityManager.getActivities(this.pathPlace);
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertEquals((Object)PATH_PLACE_ID, (Object)((Activity)activities.iterator().next()).getPlace().getIdentifier());
    }

    @Test
    public void activityBeanShouldBeCreatedOnlyOnceOnGetActivities() throws Exception {
        this.activityManager.getActivities(this.pathPlace);
        ((SyncBeanDef)Mockito.verify(this.pathIocBeanSpy, (VerificationMode)Mockito.times((int)1))).getInstance();
    }

    @Test
    public void activityBeanShouldBeCreatedOnlyOnceOnGetActivity() throws Exception {
        this.activityManager.getActivity(this.pathPlace);
        this.activityManager.getActivity(this.pathPlace);
        ((SyncBeanDef)Mockito.verify(this.pathIocBeanSpy, (VerificationMode)Mockito.times((int)1))).getInstance();
    }

    @Test
    public void shouldResolveIdentifier() throws Exception {
        Set activities = this.activityManager.getActivities(this.kansas);
        Assert.assertEquals((long)1L, (long)activities.size());
        Assert.assertEquals((Object)this.kansasActivity, activities.iterator().next());
        ((Activity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.times((int)1))).onStartup(this.kansas);
    }

    @Test
    public void shouldCallOnShutdownWhenDestroyingActivity() throws Exception {
        this.activityManager.getActivities(this.kansas);
        this.activityManager.destroyActivity(this.kansasActivity);
        ((Activity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.times((int)1))).onShutdown();
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.times((int)1))).destroyBean((Object)this.kansasActivity);
    }

    @Test
    public void shouldThrowExceptionWhenDestroyingDestroyedActivity() throws Exception {
        this.activityManager.getActivities(this.kansas);
        this.activityManager.destroyActivity(this.kansasActivity);
        try {
            this.activityManager.destroyActivity(this.kansasActivity);
            Assert.fail((String)"second destroy should have thrown an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((Activity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.times((int)1))).onShutdown();
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.times((int)1))).destroyBean((Object)this.kansasActivity);
    }

    @Test
    public void shouldNotSeeUnauthorizedActivities() throws Exception {
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.dorothy))).thenReturn((Object)false);
        Set activities = this.activityManager.getActivities(this.kansas);
        Assert.assertEquals((long)0L, (long)activities.size());
    }

    @Test
    public void shouldNotLeakUnauthorizedActivityInstances() throws Exception {
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.dorothy))).thenReturn((Object)false);
        this.activityManager.getActivities(this.kansas);
        ((ActivityBeansCache)Mockito.verify((Object)this.activityBeansCache)).getActivity("kansas");
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager)).destroyBean((Object)this.kansasActivity);
    }

    @Test
    public void shouldNotStartUnauthorizedActivities() throws Exception {
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.dorothy))).thenReturn((Object)false);
        this.activityManager.getActivities(this.kansas);
        ((Activity)Mockito.verify((Object)this.kansasActivity, (VerificationMode)Mockito.never())).onStartup(this.kansas);
    }

    @Test
    public void lookupShouldReturnNullWhenPlaceHasNoSplashScreen() throws Exception {
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        Assert.assertNull((Object)splashScreenActivity);
    }

    @Test
    public void shouldStartSplashScreens() throws Exception {
        DefaultPlaceRequest oz = new DefaultPlaceRequest("oz");
        ArrayList<SplashScreenActivity> splashScreenList = new ArrayList<SplashScreenActivity>();
        SplashScreenActivity expectedSplashScreenActivity = this.makeEnabledSplashScreenThatIntercepts(this.kansas);
        SplashScreenActivity nonExpectedSplashScreenActivity = this.makeEnabledSplashScreenThatIntercepts((PlaceRequest)oz);
        splashScreenList.add(expectedSplashScreenActivity);
        Mockito.when((Object)this.activityBeansCache.getSplashScreens()).thenReturn(splashScreenList);
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        Assert.assertSame((Object)expectedSplashScreenActivity, (Object)splashScreenActivity);
        ((SplashScreenActivity)Mockito.verify((Object)splashScreenActivity, (VerificationMode)Mockito.times((int)1))).onStartup(this.kansas);
        ((SplashScreenActivity)Mockito.verify((Object)nonExpectedSplashScreenActivity, (VerificationMode)Mockito.never())).onStartup((PlaceRequest)Matchers.any(PlaceRequest.class));
    }

    @Test
    public void shouldNotStartDisabledSplashScreens() throws Exception {
        ArrayList<SplashScreenActivity> splashScreenList = new ArrayList<SplashScreenActivity>();
        SplashScreenActivity expectedSplashScreenActivity = this.makeSplashScreenThatIntercepts(this.kansas, false);
        splashScreenList.add(expectedSplashScreenActivity);
        Mockito.when((Object)this.activityBeansCache.getSplashScreens()).thenReturn(splashScreenList);
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        Assert.assertNull((Object)splashScreenActivity);
    }

    @Test
    public void shouldStopSplashScreensWhenDestroyed() throws Exception {
        ArrayList<SplashScreenActivity> splashScreenList = new ArrayList<SplashScreenActivity>();
        SplashScreenActivity expectedSplashScreenActivity = this.makeEnabledSplashScreenThatIntercepts(this.kansas);
        splashScreenList.add(expectedSplashScreenActivity);
        Mockito.when((Object)this.activityBeansCache.getSplashScreens()).thenReturn(splashScreenList);
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        this.activityManager.destroyActivity((Activity)splashScreenActivity);
        ((SplashScreenActivity)Mockito.verify((Object)expectedSplashScreenActivity, (VerificationMode)Mockito.times((int)1))).onShutdown();
        Assert.assertFalse((boolean)this.activityManager.isStarted((Activity)expectedSplashScreenActivity));
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.never())).destroyBean((Object)expectedSplashScreenActivity);
    }

    @Test
    public void shouldNotGetConfusedAboutSplashScreensWithSamePlaceAsTheirScreen() throws Exception {
        ArrayList<SplashScreenActivity> splashScreenList = new ArrayList<SplashScreenActivity>();
        SplashScreenActivity expectedSplashScreenActivity = this.makeEnabledSplashScreenThatIntercepts(this.kansas);
        splashScreenList.add(expectedSplashScreenActivity);
        Mockito.when((Object)this.activityBeansCache.getSplashScreens()).thenReturn(splashScreenList);
        this.activityManager.getActivity(this.kansas);
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        this.activityManager.destroyActivity((Activity)splashScreenActivity);
        ((SplashScreenActivity)Mockito.verify((Object)expectedSplashScreenActivity, (VerificationMode)Mockito.times((int)1))).onShutdown();
        Assert.assertFalse((boolean)this.activityManager.isStarted((Activity)expectedSplashScreenActivity));
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.never())).destroyBean((Object)expectedSplashScreenActivity);
    }

    @Test
    public void shouldThrowExceptionWhenDoubleDestroyingSplashScreen() throws Exception {
        ArrayList<SplashScreenActivity> splashScreenList = new ArrayList<SplashScreenActivity>();
        SplashScreenActivity expectedSplashScreenActivity = this.makeEnabledSplashScreenThatIntercepts(this.kansas);
        splashScreenList.add(expectedSplashScreenActivity);
        Mockito.when((Object)this.activityBeansCache.getSplashScreens()).thenReturn(splashScreenList);
        SplashScreenActivity splashScreenActivity = this.activityManager.getSplashScreenInterceptor(this.kansas);
        this.activityManager.destroyActivity((Activity)splashScreenActivity);
        try {
            this.activityManager.destroyActivity((Activity)splashScreenActivity);
            Assert.fail((String)"should have thrown exception on double destroy");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((SplashScreenActivity)Mockito.verify((Object)expectedSplashScreenActivity, (VerificationMode)Mockito.times((int)1))).onShutdown();
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.never())).destroyBean((Object)expectedSplashScreenActivity);
    }

    @Test
    public void shouldNotAttemptToDestroyRuntimeRegisteredSingletonActivities() throws Exception {
        String myPerspectiveId = "myPerspectiveId";
        abstract class MyPerspectiveActivity
        implements PerspectiveActivity {
            MyPerspectiveActivity() {
            }
        }
        MyPerspectiveActivity activity = (MyPerspectiveActivity)Mockito.mock(MyPerspectiveActivity.class);
        Mockito.when((Object)activity.getPlace()).thenReturn((Object)new DefaultPlaceRequest("myPerspectiveId"));
        SyncBeanDef<MyPerspectiveActivity> perspectiveActivityBean = this.makeSingletonBean(PerspectiveActivity.class, activity, "myPerspectiveId");
        Mockito.when((Object)this.activityBeansCache.getActivity("myPerspectiveId")).thenReturn(perspectiveActivityBean);
        Activity retrievedActivity = this.activityManager.getActivity(Activity.class, (PlaceRequest)new DefaultPlaceRequest("myPerspectiveId"));
        this.activityManager.destroyActivity(retrievedActivity);
        ((SyncBeanManagerImpl)Mockito.verify((Object)this.iocManager, (VerificationMode)Mockito.never())).destroyBean((Object)activity);
    }

    private SplashScreenActivity makeEnabledSplashScreenThatIntercepts(PlaceRequest place) {
        return this.makeSplashScreenThatIntercepts(place, true);
    }

    private SplashScreenActivity makeSplashScreenThatIntercepts(PlaceRequest place, boolean enabled) {
        String splashActivityName = place.getIdentifier() + "!Splash";
        SplashScreenActivity splashScreenActivity = (SplashScreenActivity)Mockito.mock(SplashScreenActivity.class);
        Mockito.when((Object)splashScreenActivity.isEnabled()).thenReturn((Object)enabled);
        Mockito.when((Object)splashScreenActivity.intercept(place)).thenReturn((Object)true);
        this.makeSingletonBean(SplashScreenActivity.class, splashScreenActivity);
        return splashScreenActivity;
    }

    private <T> SyncBeanDef<T> makeDependentBean(Class<T> type, T beanInstance) {
        MockIOCBeanDef<T, T> beanDef = new MockIOCBeanDef<T, T>(beanInstance, type, Dependent.class, null, beanInstance.getClass().getSimpleName(), true, new Class[0]);
        Mockito.when((Object)this.iocManager.lookupBean(beanInstance.getClass(), new Annotation[0])).thenReturn(beanDef);
        return beanDef;
    }

    private <T> IOCBeanDef<T> makeSingletonBean(Class<T> type, T beanInstance) {
        return this.makeSingletonBean(type, beanInstance, type.getSimpleName());
    }

    private <T> SyncBeanDef<T> makeSingletonBean(Class<T> type, T beanInstance, String name) {
        MockIOCBeanDef<T, T> beanDef = new MockIOCBeanDef<T, T>(beanInstance, type, ApplicationScoped.class, null, name, true, new Class[0]);
        Mockito.when((Object)this.iocManager.lookupBean(beanInstance.getClass(), new Annotation[0])).thenReturn(beanDef);
        return beanDef;
    }
}

