/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.widgets.dnd.CompassDropControllerUnitTestWrapper;
import org.uberfire.client.workbench.widgets.dnd.CompassWidget;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class CompassDropControllerTest {
    private CompassDropControllerUnitTestWrapper compassDropController;
    @GwtMock
    private WorkbenchPanelView view;
    @GwtMock
    private WorkbenchDragAndDropManager dndManager;
    @GwtMock
    private PanelManager panelManager;

    @Before
    public void setup() {
        this.compassDropController = new CompassDropControllerUnitTestWrapper();
        this.compassDropController.setupMocks(this.dndManager, this.panelManager);
    }

    @Test
    public void setupTest() {
        this.compassDropController.setup(this.view);
        Assert.assertEquals((Object)this.view, (Object)this.compassDropController.dropTarget);
    }

    @Test
    public void compassDelegationTest() {
        CompassWidget compass = this.compassDropController.compass;
        DragContext dragContext = (DragContext)Mockito.mock(DragContext.class);
        this.compassDropController.onEnter(dragContext);
        ((CompassWidget)Mockito.verify((Object)compass)).onEnter(dragContext);
        this.compassDropController.onLeave(dragContext);
        ((CompassWidget)Mockito.verify((Object)compass)).onLeave(dragContext);
        this.compassDropController.onMove(dragContext);
        ((CompassWidget)Mockito.verify((Object)compass)).onMove(dragContext);
    }

    @Test
    public void onDropDoesNothing() {
        this.compassDropController.mockDropTargetPositionNone();
        DragContext dragContext = (DragContext)Mockito.mock(DragContext.class);
        this.compassDropController.onDrop(dragContext);
        ((CompassWidget)Mockito.verify((Object)this.compassDropController.compass, (VerificationMode)Mockito.never())).onDrop(dragContext);
    }

    @Test
    public void onDropNoEffect() {
        this.compassDropController.mockDropTargetPosition((Position)CompassPosition.SELF);
        this.compassDropController.mockSamePositionDrag(this.view);
        DragContext dragContext = (DragContext)Mockito.mock(DragContext.class);
        this.compassDropController.onDrop(dragContext);
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).addWorkbenchPanel((PanelDefinition)Matchers.any(), (Position)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any());
    }

    @Test
    public void onDropHappens() {
        this.compassDropController.mockDropTargetPosition((Position)CompassPosition.WEST);
        this.compassDropController.mockSamePositionDrag(this.view);
        DragContext dragContext = (DragContext)Mockito.mock(DragContext.class);
        this.compassDropController.onDrop(dragContext);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel((PanelDefinition)Matchers.any(), (Position)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any(), (Integer)Matchers.any());
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPart((PlaceRequest)Matchers.any(), (PartDefinition)Matchers.any(), (PanelDefinition)Matchers.any(), (Menus)Matchers.any(), (UIPart)Matchers.any(), (String)Matchers.any(), (Integer)Matchers.isNull(), (Integer)Matchers.isNull());
    }
}

