/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMenuBarPresenterTest {
    private static final String NAME = "testName";
    private static final String PERSPECTIVE_ID = "perspectiveId";
    private static final String SECOND_PERSPECTIVE_ID = "secondPerspectiveId";
    private static final String THIRD_PERSPECTIVE_ID = "thirdPerspectiveId";
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    protected User identity;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private WorkbenchMenuBarPresenter.View view;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    @InjectMocks
    private WorkbenchMenuBarPresenter presenter;

    @Test
    public void testAddCurrentPerspective() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(PERSPECTIVE_ID);
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testAddPerspective() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("anyId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testPerspectiveChangeEvent() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(PERSPECTIVE_ID);
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveChange perspectiveChange = new PerspectiveChange((PlaceRequest)placeRequest, null, null, PERSPECTIVE_ID);
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(Resource.class), (User)Matchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        this.presenter.onPerspectiveChange(perspectiveChange);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testAddMenuWithPermission() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addMenuItem((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)NAME), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddMenuWithoutPermission() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)false);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addMenuItem((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)NAME), (String)Matchers.isNull(String.class), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenuWithPermission() {
        MenuPosition position = MenuPosition.LEFT;
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)Matchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItem((String)Matchers.eq((Object)PERSPECTIVE_ID), Matchers.anyString(), (String)Matchers.eq((Object)NAME), (String)Matchers.isNull(), (Command)Matchers.any(), (MenuPosition)Matchers.eq((Object)position));
    }

    @Test
    public void testAddContextMenuWithoutPermission() {
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)Matchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addContextMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testSetupEnableDisableMenuItemCommand() {
        Command command = (Command)Mockito.mock(Command.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).respondsWith(command)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPlace() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).place(place)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPerspective() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableContextMenuItem() {
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)Matchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).enableContextMenuItem(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testMenuInsertionOrder() {
        Menus firstMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Menus secondMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).orderAll(1)).perspective(SECOND_PERSPECTIVE_ID)).endMenu()).build();
        Menus thirdMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).orderAll(2)).perspective(THIRD_PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)firstMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)secondMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)thirdMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(thirdMenus);
        this.presenter.addMenus(firstMenus);
        this.presenter.addMenus(secondMenus);
        Assert.assertEquals((long)3L, (long)this.presenter.getAddedMenus().size());
        Assert.assertSame((Object)firstMenus, this.presenter.getAddedMenus().get(0));
        Assert.assertSame((Object)secondMenus, this.presenter.getAddedMenus().get(1));
        Assert.assertSame((Object)thirdMenus, this.presenter.getAddedMenus().get(2));
    }

    @Test
    public void testAddMenusWithExperimentalPerspective() {
        Mockito.when((Object)this.authzManager.authorize((Resource)Matchers.any(MenuItem.class), (User)Matchers.any())).thenReturn((Object)true);
        ArrayList items = new ArrayList();
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(SECOND_PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(THIRD_PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        Menus menus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).withItems(items).endMenu()).build();
        Mockito.when((Object)this.experimentalActivitiesAuthorizationManager.authorizeActivityId(Matchers.anyString())).thenAnswer(invocationOnMock -> !SECOND_PERSPECTIVE_ID.equals(invocationOnMock.getArguments()[0]));
        this.presenter.addMenus(menus);
        ((ExperimentalActivitiesAuthorizationManager)Mockito.verify((Object)this.experimentalActivitiesAuthorizationManager, (VerificationMode)Mockito.times((int)3))).authorizeActivityId(Matchers.anyString());
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setMenuItemVisible(Matchers.anyString(), Matchers.eq((boolean)true));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).setMenuItemVisible(Matchers.anyString(), Matchers.eq((boolean)false));
    }

    @Test
    public void testShowHideExperimentalPerspectiveMenus() {
        this.testAddMenusWithExperimentalPerspective();
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(PERSPECTIVE_ID, false));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).setMenuItemVisible(PERSPECTIVE_ID, false);
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(SECOND_PERSPECTIVE_ID, true));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).setMenuItemVisible(SECOND_PERSPECTIVE_ID, true);
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(THIRD_PERSPECTIVE_ID, false));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).setMenuItemVisible(THIRD_PERSPECTIVE_ID, false);
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testCollapse() {
        this.presenter.collapse();
        Assert.assertFalse((boolean)this.presenter.isUseExpandedMode());
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).collapse();
    }

    @Test
    public void testExpand() {
        this.presenter.expand();
        Assert.assertTrue((boolean)this.presenter.isUseExpandedMode());
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).expand();
    }

    @Test
    public void testAddCollapseHandler() {
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.addCollapseHandler(command);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addCollapseHandler(command);
    }

    @Test
    public void testExpandHandler() {
        ((WorkbenchMenuBarPresenter.View)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Command)invocation.getArguments()[0]).execute();
                return null;
            }
        }).when((Object)this.view)).addExpandHandler((Command)Matchers.any(Command.class));
        this.presenter.setup();
        Assert.assertTrue((boolean)this.presenter.isExpanded());
    }

    @Test
    public void testCollapseHandler() {
        ((WorkbenchMenuBarPresenter.View)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((Command)invocation.getArguments()[0]).execute();
                return null;
            }
        }).when((Object)this.view)).addCollapseHandler((Command)Matchers.any(Command.class));
        this.presenter.setup();
        Assert.assertFalse((boolean)this.presenter.isExpanded());
    }

    @Test
    public void testAddExpandHandler() {
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.addExpandHandler(command);
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).addExpandHandler(command);
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testOnPlaceMaximized() {
        this.presenter.onPlaceMaximized((PlaceMaximizedEvent)Mockito.mock(PlaceMaximizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).collapse();
    }

    @Test
    public void testOnPlaceMinimized() {
        this.presenter.onPlaceMinimized((PlaceMinimizedEvent)Mockito.mock(PlaceMinimizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view)).expand();
    }

    @Test
    public void testOnPlaceMinimizedExpandMode() {
        this.presenter.collapse();
        this.presenter.onPlaceMinimized((PlaceMinimizedEvent)Mockito.mock(PlaceMinimizedEvent.class));
        ((WorkbenchMenuBarPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).expand();
    }
}

