/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu;

import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuStandalonePresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.brand.MegaMenuBrand;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMegaMenuStandalonePresenterTest {
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    protected User identity;
    @Mock
    private WorkbenchMegaMenuPresenter.View view;
    @Mock
    private ManagedInstance<MegaMenuBrand> megaMenuBrands;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    @Mock
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    @Mock
    private Workbench workbench;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    private WorkbenchMegaMenuStandalonePresenter presenter;

    @Before
    public void setup() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isUnsatisfied();
        this.presenter = (WorkbenchMegaMenuStandalonePresenter)Mockito.spy((Object)new WorkbenchMegaMenuStandalonePresenter(this.authzManager, this.perspectiveManager, this.activityManager, this.identity, this.view, this.megaMenuBrands, this.placeManager, this.authorizationManager, this.sessionInfo, this.childMenuItemPresenters, this.groupMenuItemPresenters, this.childContextMenuItemPresenters, this.groupContextMenuItemPresenters, this.workbench, this.experimentalActivitiesAuthorizationManager));
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(ChildMenuItemPresenter.class)).when(this.childMenuItemPresenters)).get();
    }

    @Test
    public void testAddMenus() {
        String perspectiveId = "perspectiveId";
        String label = "perspectiveLabel";
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective("perspectiveId")).endMenu()).build();
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager, (VerificationMode)Mockito.never())).authorize((Resource)Matchers.any(MenuItem.class), (User)Matchers.any(User.class));
        ((WorkbenchMegaMenuStandalonePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenus() {
        String perspectiveId = "perspectiveId";
        String contextLabel = "contextLabel";
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)Matchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, "perspectiveId"));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuStandalonePresenter)Mockito.verify((Object)this.presenter)).addMenuItem(Matchers.anyString(), (String)Matchers.eq((Object)"contextLabel"), (String)Matchers.isNull(String.class), (Command)Matchers.isNull(Command.class), (MenuPosition)Matchers.eq((Object)MenuPosition.LEFT));
        ((WorkbenchMegaMenuStandalonePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).clearContextMenu();
        ((WorkbenchMegaMenuStandalonePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addContextMenuItem(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (Command)Matchers.any(Command.class), (MenuPosition)Matchers.any(MenuPosition.class));
    }
}

