/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.common.collect.Maps;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.Footer;
import org.uberfire.client.workbench.Header;
import org.uberfire.client.workbench.WorkbenchLayoutImpl;
import org.uberfire.client.workbench.docks.UberfireDocksContainer;
import org.uberfire.client.workbench.events.WorkbenchProfileCssClass;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={DockLayoutPanel.class})
public class WorkbenchLayoutImplTest {
    @Mock
    UberfireDocksContainer uberfireDocksContainer;
    @Mock
    WorkbenchPickupDragController dragController;
    private WorkbenchLayoutImpl workbenchLayout;
    private Widget widget;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private HeaderPanel root;
    @Mock
    private Div headerPanel;
    @Mock
    private Div footerPanel;
    @Mock
    private WorkbenchDragAndDropManager dndManager;
    private Header header1;
    private Header header2;
    private Footer footer1;
    private Footer footer2;

    @Before
    public void setup() {
        this.workbenchLayout = new WorkbenchLayoutImpl(this.iocManager, this.root, this.dndManager, this.uberfireDocksContainer, this.dragController, this.headerPanel, this.footerPanel){

            ElementWrapperWidget<?> createWidgetFrom(HTMLElement h) {
                return (ElementWrapperWidget)Mockito.mock(ElementWrapperWidget.class);
            }
        };
        this.widget = (Widget)Mockito.mock(Widget.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{RequiresResize.class}));
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)element.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.widget.getElement()).thenReturn((Object)element);
        this.header1 = (Header)Mockito.mock(Header.class);
        this.header2 = (Header)Mockito.mock(Header.class);
        this.footer1 = (Footer)Mockito.mock(Footer.class);
        this.footer2 = (Footer)Mockito.mock(Footer.class);
    }

    @Test
    public void testMaximize() {
        this.workbenchLayout.maximize(this.widget);
        ((Widget)Mockito.verify((Object)this.widget)).addStyleName("uf-maximized-panel");
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget), (VerificationMode)Mockito.never())).onResize();
    }

    @Test
    public void testExpandAnimation() {
        WorkbenchLayoutImpl.ExpandAnimation expandAnimation = new WorkbenchLayoutImpl.ExpandAnimation(this.widget, (Map)Maps.newHashMap(), (SimpleLayoutPanel)Mockito.mock(SimpleLayoutPanel.class), null);
        expandAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
    }

    @Test
    public void testExpandAnimationWithCallback() {
        Command callback = (Command)Mockito.mock(Command.class);
        WorkbenchLayoutImpl.ExpandAnimation expandAnimation = new WorkbenchLayoutImpl.ExpandAnimation(this.widget, (Map)Maps.newHashMap(), (SimpleLayoutPanel)Mockito.mock(SimpleLayoutPanel.class), callback);
        expandAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
        ((Command)Mockito.verify((Object)callback)).execute();
    }

    @Test
    public void testUnMaximize() {
        this.workbenchLayout.maximize(this.widget);
        this.workbenchLayout.unmaximize(this.widget);
        ((Widget)Mockito.verify((Object)this.widget)).addStyleName("uf-maximized-panel");
        ((Widget)Mockito.verify((Object)this.widget)).removeStyleName("uf-maximized-panel");
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget), (VerificationMode)Mockito.never())).onResize();
    }

    @Test
    public void testCollapseAnimation() {
        HashMap maximizedWidgetOriginalStyles = Maps.newHashMap();
        maximizedWidgetOriginalStyles.put(this.widget, new WorkbenchLayoutImpl.OriginalStyleInfo(this.widget));
        WorkbenchLayoutImpl.CollapseAnimation collapseAnimation = new WorkbenchLayoutImpl.CollapseAnimation(this.widget, (Map)maximizedWidgetOriginalStyles, null);
        collapseAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
    }

    @Test
    public void testCollapseAnimationWithCallback() {
        HashMap maximizedWidgetOriginalStyles = Maps.newHashMap();
        maximizedWidgetOriginalStyles.put(this.widget, new WorkbenchLayoutImpl.OriginalStyleInfo(this.widget));
        Command callback = (Command)Mockito.mock(Command.class);
        WorkbenchLayoutImpl.CollapseAnimation collapseAnimation = new WorkbenchLayoutImpl.CollapseAnimation(this.widget, (Map)maximizedWidgetOriginalStyles, callback);
        collapseAnimation.onComplete();
        ((RequiresResize)Mockito.verify((Object)((RequiresResize)this.widget))).onResize();
        ((Command)Mockito.verify((Object)callback)).execute();
    }

    @Test
    public void setEmptyHeaderContentsTest() {
        Div headerPanel = this.workbenchLayout.getHeaderPanel();
        this.workbenchLayout.setHeaderContents(new ArrayList());
        ((Div)Mockito.verify((Object)headerPanel, (VerificationMode)Mockito.never())).appendChild((Node)Mockito.any());
        ((HeaderPanel)Mockito.verify((Object)this.root, (VerificationMode)Mockito.never())).setHeaderWidget((Widget)Mockito.any());
    }

    @Test
    public void setHeaderContentsTest() {
        Div headerPanel = this.workbenchLayout.getHeaderPanel();
        List<Header> headers = Arrays.asList(this.header1, this.header2);
        this.workbenchLayout.setHeaderContents(headers);
        ((Div)Mockito.verify((Object)headerPanel, (VerificationMode)Mockito.times((int)2))).appendChild((Node)Mockito.any());
        ((HeaderPanel)Mockito.verify((Object)this.root)).setHeaderWidget((Widget)Mockito.any());
    }

    @Test
    public void setEmptyFooterContentsTest() {
        Div footerPanel = this.workbenchLayout.getFooterPanel();
        this.workbenchLayout.setFooterContents(new ArrayList());
        ((Div)Mockito.verify((Object)footerPanel, (VerificationMode)Mockito.never())).appendChild((Node)Mockito.any());
        ((HeaderPanel)Mockito.verify((Object)this.root, (VerificationMode)Mockito.never())).setFooterWidget((Widget)Mockito.any());
    }

    @Test
    public void setFooterContentsTest() {
        Div footerPanel = this.workbenchLayout.getFooterPanel();
        List<Footer> footers = Arrays.asList(this.footer1, this.footer2);
        this.workbenchLayout.setFooterContents(footers);
        ((Div)Mockito.verify((Object)footerPanel, (VerificationMode)Mockito.times((int)2))).appendChild((Node)Mockito.any());
        ((HeaderPanel)Mockito.verify((Object)this.root)).setFooterWidget((Widget)Mockito.any());
    }

    @Test
    public void addWorkbenchProfileCssClass() {
        Mockito.when((Object)this.root.getStyleName()).thenReturn((Object)"current stylename");
        this.workbenchLayout.addWorkbenchProfileCssClass(new WorkbenchProfileCssClass("dora"));
        ((HeaderPanel)Mockito.verify((Object)this.root)).removeStyleName("current stylename");
        ((HeaderPanel)Mockito.verify((Object)this.root)).addStyleName("uf-workbench-layout");
        ((HeaderPanel)Mockito.verify((Object)this.root)).addStyleName("dora");
    }
}

