/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu.megamenu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.widgets.menu.events.PerspectiveVisibiltiyChangeEvent;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.CanBeDisabled;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.CanHide;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.HasChildren;
import org.uberfire.client.workbench.widgets.menu.megamenu.brand.MegaMenuBrand;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkbenchMegaMenuPresenterTest {
    private static final String NAME = "testName";
    private static final String PERSPECTIVE_ID = "perspectiveId";
    private static final String SECOND_PERSPECTIVE_ID = "secondPerspectiveId";
    private static final String THIRD_PERSPECTIVE_ID = "thirdPerspectiveId";
    @Mock
    protected AuthorizationManager authzManager;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    protected User identity;
    @Mock
    private ManagedInstance<MegaMenuBrand> megaMenuBrands;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    @Mock
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    @Mock
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    @Mock
    private Workbench workbench;
    @Mock
    private WorkbenchMegaMenuPresenter.View view;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    private WorkbenchMegaMenuPresenter presenter;

    @Before
    public void setup() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isUnsatisfied();
        this.presenter = (WorkbenchMegaMenuPresenter)Mockito.spy((Object)new WorkbenchMegaMenuPresenter(this.authzManager, this.perspectiveManager, this.activityManager, this.identity, this.view, this.megaMenuBrands, this.placeManager, this.authorizationManager, this.sessionInfo, this.childMenuItemPresenters, this.groupMenuItemPresenters, this.childContextMenuItemPresenters, this.groupContextMenuItemPresenters, this.workbench, this.experimentalActivitiesAuthorizationManager));
        Mockito.reset((Object[])new WorkbenchMegaMenuPresenter.View[]{this.view});
        this.presenter.selectableMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        this.presenter.hasChildrenMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        this.presenter.canBeDisabledMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        this.presenter.canHideMenuItemByIdentifier = (Map)Mockito.spy(new HashMap());
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(ChildMenuItemPresenter.class)).when(this.childMenuItemPresenters)).get();
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(GroupMenuItemPresenter.class)).when(this.groupMenuItemPresenters)).get();
        ((ManagedInstance)Mockito.doReturn((Object)Mockito.mock(ChildContextMenuItemPresenter.class)).when(this.childContextMenuItemPresenters)).get();
    }

    @Test
    public void testAddCurrentPerspective() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(PERSPECTIVE_ID);
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)ArgumentMatchers.any(Resource.class), (User)ArgumentMatchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testAddPerspective() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("anyId");
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)perspectiveActivity.getPlace()).thenReturn((Object)placeRequest);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)perspectiveActivity);
        Mockito.when((Object)this.authzManager.authorize((Resource)ArgumentMatchers.any(Resource.class), (User)ArgumentMatchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testPerspectiveChangeEvent() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest(PERSPECTIVE_ID);
        PerspectiveActivity perspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PerspectiveChange perspectiveChange = new PerspectiveChange((PlaceRequest)placeRequest, null, null, PERSPECTIVE_ID);
        Mockito.when((Object)this.authzManager.authorize((Resource)ArgumentMatchers.any(Resource.class), (User)ArgumentMatchers.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        this.presenter.onPerspectiveChange(perspectiveChange);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).selectMenuItem(PERSPECTIVE_ID);
    }

    @Test
    public void testAddMenuWithPermission() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).addMenuItem((String)ArgumentMatchers.eq((Object)PERSPECTIVE_ID), (String)ArgumentMatchers.eq((Object)NAME), (String)ArgumentMatchers.isNull(String.class), (Command)ArgumentMatchers.any(Command.class), (MenuPosition)ArgumentMatchers.any(MenuPosition.class));
    }

    @Test
    public void testAddMenuWithoutPermission() {
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)false);
        this.presenter.addMenus(menus);
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)menus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addMenuItem((String)ArgumentMatchers.eq((Object)PERSPECTIVE_ID), (String)ArgumentMatchers.eq((Object)NAME), (String)ArgumentMatchers.isNull(String.class), (Command)ArgumentMatchers.any(Command.class), (MenuPosition)ArgumentMatchers.any(MenuPosition.class));
    }

    @Test
    public void testAddContextMenuWithPermission() {
        MenuPosition position = MenuPosition.LEFT;
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)ArgumentMatchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).addContextMenuItem((String)ArgumentMatchers.eq((Object)PERSPECTIVE_ID), ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)NAME), (String)ArgumentMatchers.isNull(), (Command)ArgumentMatchers.any(), (MenuPosition)ArgumentMatchers.eq((Object)position));
    }

    @Test
    public void testAddContextMenuWithoutPermission() {
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)ArgumentMatchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)false);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((AuthorizationManager)Mockito.verify((Object)this.authzManager)).authorize((Resource)contextMenus.getItems().get(0), this.identity);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addContextMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Command)ArgumentMatchers.any(Command.class), (MenuPosition)ArgumentMatchers.any(MenuPosition.class));
    }

    @Test
    public void testSetupEnableDisableMenuItemCommand() {
        String label = "command";
        Command command = (Command)Mockito.mock(Command.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"command").respondsWith(command)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPlace() {
        String label = "placeLabel";
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"placeLabel").place(place)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableMenuItemPerspective() {
        String label = "perspectiveLabel";
        String perspectiveId = PERSPECTIVE_ID;
        Menus menus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)menus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(menus);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)menus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testSetupEnableDisableContextMenuItem() {
        String contextLabel = "contextLabel";
        String perspectiveId = PERSPECTIVE_ID;
        Menus contextMenus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)"contextLabel").endMenu()).build();
        PerspectiveActivity activity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)activity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        ((PerspectiveActivity)Mockito.doAnswer(invocationOnMock -> {
            ((Consumer)invocationOnMock.getArgument(0, Consumer.class)).accept(contextMenus);
            return null;
        }).when((Object)activity)).getMenus((Consumer)ArgumentMatchers.any());
        Mockito.when((Object)activity.isType(ActivityResourceType.PERSPECTIVE.name())).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)contextMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivity(placeRequest)).thenReturn((Object)activity);
        this.presenter.onPerspectiveChange(new PerspectiveChange(placeRequest, null, contextMenus, PERSPECTIVE_ID));
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableContextMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).enableContextMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)true));
        ((MenuItem)contextMenus.getItems().get(0)).setEnabled(false);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableContextMenuItem(ArgumentMatchers.anyString(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testMenuInsertionOrder() {
        String perspectiveId = PERSPECTIVE_ID;
        String label = "perspectiveLabel";
        Menus firstMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").perspective(PERSPECTIVE_ID)).endMenu()).build();
        Menus secondMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(1)).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Menus thirdMenus = ((MenuFactory.Builder)((MenuFactory.MenuBuilder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"perspectiveLabel").orderAll(2)).perspective(PERSPECTIVE_ID)).endMenu()).build();
        Mockito.when((Object)this.authzManager.authorize((Resource)firstMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)secondMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        Mockito.when((Object)this.authzManager.authorize((Resource)thirdMenus.getItems().get(0), this.identity)).thenReturn((Object)true);
        this.presenter.addMenus(thirdMenus);
        this.presenter.addMenus(firstMenus);
        this.presenter.addMenus(secondMenus);
        Assert.assertEquals((long)3L, (long)this.presenter.getAddedMenus().size());
        Assert.assertSame((Object)firstMenus, this.presenter.getAddedMenus().get(0));
        Assert.assertSame((Object)secondMenus, this.presenter.getAddedMenus().get(1));
        Assert.assertSame((Object)thirdMenus, this.presenter.getAddedMenus().get(2));
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test(expected=RuntimeException.class)
    public void setupWithMoreThanOneMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isAmbiguous();
        this.presenter.setup();
    }

    @Test
    public void setupWithNoMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)true).when(this.megaMenuBrands)).isUnsatisfied();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).hideBrand();
    }

    @Test
    public void setupWithOneEmptyMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isAmbiguous();
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isUnsatisfied();
        MegaMenuBrandMock megaMenuBrand = new MegaMenuBrandMock("", "", "");
        ((ManagedInstance)Mockito.doReturn((Object)megaMenuBrand).when(this.megaMenuBrands)).get();
        ((WorkbenchMegaMenuPresenter.View)Mockito.doReturn((Object)"defaultMenuText").when((Object)this.view)).getDefaultMenuText();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setBrandImage(ArgumentMatchers.anyString());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setBrandImageTitle(ArgumentMatchers.anyString());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).hideBrand();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setMenuAccessorText(this.view.getDefaultMenuText());
    }

    @Test
    public void setupWithOneMegaMenuBrandImplementationTest() {
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isAmbiguous();
        ((ManagedInstance)Mockito.doReturn((Object)false).when(this.megaMenuBrands)).isUnsatisfied();
        MegaMenuBrandMock megaMenuBrand = new MegaMenuBrandMock("brandImageUrl", "brandImageLabel", "menuAccessorLabel");
        ((ManagedInstance)Mockito.doReturn((Object)megaMenuBrand).when(this.megaMenuBrands)).get();
        ((WorkbenchMegaMenuPresenter.View)Mockito.doReturn((Object)"defaultMenuText").when((Object)this.view)).getDefaultMenuText();
        this.presenter.setup();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImage(megaMenuBrand.brandImageUrl());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImageTitle(megaMenuBrand.brandImageLabel());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideBrand();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setMenuAccessorText(megaMenuBrand.menuAccessorLabel());
    }

    @Test
    public void addMenuItemWithParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        HasChildren parent = (HasChildren)Mockito.mock(HasChildren.class);
        this.presenter.hasChildrenMenuItemByIdentifier.put("parentId", parent);
        this.presenter.addMenuItem("id", "label", "parentId", (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)ArgumentMatchers.eq((Object)"label"), (Command)ArgumentMatchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnParent(childMenuItemPresenter, parent);
    }

    @Test
    public void addMenuItemOnTheRightWithoutParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        this.presenter.addMenuItem("id", "label", null, (Command)Mockito.mock(Command.class), MenuPosition.RIGHT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)ArgumentMatchers.eq((Object)"label"), (Command)ArgumentMatchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnRight(childMenuItemPresenter);
    }

    @Test
    public void addMenuItemOnTheLeftWithoutParentTest() {
        ChildMenuItemPresenter childMenuItemPresenter = (ChildMenuItemPresenter)Mockito.mock(ChildMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)childMenuItemPresenter).when(this.childMenuItemPresenters)).get();
        this.presenter.addMenuItem("id", "label", null, (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildMenuItemPresenter)Mockito.verify((Object)childMenuItemPresenter)).setup((String)ArgumentMatchers.eq((Object)"label"), (Command)ArgumentMatchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addMenuItemOnLeft(childMenuItemPresenter);
    }

    @Test
    public void addCustomIsElementMenuItemTest() {
        IsElement menu = (IsElement)Mockito.mock(IsElement.class);
        this.presenter.addCustomMenuItem((org.jboss.errai.common.client.api.IsElement)menu, MenuPosition.RIGHT);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addCustomMenuItem((org.jboss.errai.common.client.api.IsElement)menu);
    }

    @Test
    public void addCustomIsWidgetMenuItemTest() {
        IsWidget menu = (IsWidget)Mockito.mock(IsWidget.class);
        this.presenter.addCustomMenuItem(menu, MenuPosition.RIGHT);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addCustomMenuItem(menu);
    }

    @Test
    public void addGroupMenuItemTest() {
        GroupMenuItemPresenter groupMenuItemPresenter = (GroupMenuItemPresenter)Mockito.mock(GroupMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)groupMenuItemPresenter).when(this.groupMenuItemPresenters)).get();
        this.presenter.addGroupMenuItem("id", "label", MenuPosition.LEFT);
        ((GroupMenuItemPresenter)Mockito.verify((Object)groupMenuItemPresenter)).setup((String)ArgumentMatchers.eq((Object)"label"));
        ((Map)Mockito.verify((Object)this.presenter.hasChildrenMenuItemByIdentifier)).put("id", groupMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addGroupMenuItem(groupMenuItemPresenter);
    }

    @Test
    public void addContextMenuItemTest() {
        ChildContextMenuItemPresenter childContextMenuItemPresenter = (ChildContextMenuItemPresenter)Mockito.mock(ChildContextMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)childContextMenuItemPresenter).when(this.childContextMenuItemPresenters)).get();
        HasChildren parent = (HasChildren)Mockito.mock(HasChildren.class);
        this.presenter.hasChildrenMenuItemByIdentifier.put("parentId", parent);
        this.presenter.addContextMenuItem("menuItemId", "id", "label", "parentId", (Command)Mockito.mock(Command.class), MenuPosition.LEFT);
        ((ChildContextMenuItemPresenter)Mockito.verify((Object)childContextMenuItemPresenter)).setup((String)ArgumentMatchers.eq((Object)"label"), (Command)ArgumentMatchers.any());
        ((Map)Mockito.verify((Object)this.presenter.selectableMenuItemByIdentifier)).put("id", childContextMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", childContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItemOnParent(childContextMenuItemPresenter, parent);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setContextMenuActive(true);
    }

    @Test
    public void addContextGroupMenuItemTest() {
        GroupContextMenuItemPresenter groupContextMenuItemPresenter = (GroupContextMenuItemPresenter)Mockito.mock(GroupContextMenuItemPresenter.class);
        ((ManagedInstance)Mockito.doReturn((Object)groupContextMenuItemPresenter).when(this.groupContextMenuItemPresenters)).get();
        this.presenter.addContextGroupMenuItem("menuItemId", "id", "label", MenuPosition.LEFT);
        ((GroupContextMenuItemPresenter)Mockito.verify((Object)groupContextMenuItemPresenter)).setup("label");
        ((Map)Mockito.verify((Object)this.presenter.hasChildrenMenuItemByIdentifier)).put("id", groupContextMenuItemPresenter);
        ((Map)Mockito.verify((Object)this.presenter.canBeDisabledMenuItemByIdentifier)).put("id", groupContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).addContextMenuItem(groupContextMenuItemPresenter);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setContextMenuActive(true);
    }

    @Test
    public void clearContextMenuTest() {
        this.view.clearContextMenu();
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).clearContextMenu();
    }

    @Test
    public void enableMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableMenuItem("id", true);
        ((CanBeDisabled)Mockito.verify((Object)menuItem)).enable();
    }

    @Test
    public void disableMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableMenuItem("id", false);
        ((CanBeDisabled)Mockito.verify((Object)menuItem)).disable();
    }

    @Test
    public void enableContextMenuItemTest() {
        CanBeDisabled menuItem = (CanBeDisabled)Mockito.mock(CanBeDisabled.class);
        this.presenter.canBeDisabledMenuItemByIdentifier.put("id", menuItem);
        this.presenter.enableContextMenuItem("id", true);
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.presenter)).enableMenuItem("id", true);
    }

    @Test
    public void setupHomeLinkWithNoDefaultPerspective() {
        ((Workbench)Mockito.doReturn(null).when((Object)this.workbench)).getHomePerspectiveActivity();
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImageAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo(ArgumentMatchers.anyString());
    }

    @Test
    public void setupHomeLinkWithNoPermissionToAccessDefaultPerspective() {
        PerspectiveActivity homePerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((PerspectiveActivity)Mockito.doReturn((Object)"identifier").when((Object)homePerspective)).getIdentifier();
        ((Workbench)Mockito.doReturn((Object)homePerspective).when((Object)this.workbench)).getHomePerspectiveActivity();
        ((WorkbenchMegaMenuPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasAccessToPerspective((String)ArgumentMatchers.any());
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImageAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo(ArgumentMatchers.anyString());
    }

    @Test
    public void setupHomeLinkWithPermissionToAccessDefaultPerspective() {
        PerspectiveActivity homePerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        ((PerspectiveActivity)Mockito.doReturn((Object)"identifier").when((Object)homePerspective)).getIdentifier();
        ((Workbench)Mockito.doReturn((Object)homePerspective).when((Object)this.workbench)).getHomePerspectiveActivity();
        ((WorkbenchMegaMenuPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasAccessToPerspective((String)ArgumentMatchers.any());
        this.presenter.setupHomeLink();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Command.class);
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setHomeLinkAction((Command)commandCaptor.capture());
        ((WorkbenchMegaMenuPresenter.View)Mockito.verify((Object)this.view)).setBrandImageAction((Command)commandCaptor.capture());
        ((Command)commandCaptor.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("identifier");
    }

    @Test
    public void testAddMenusWithExperimentalPerspective() {
        Mockito.when((Object)this.authzManager.authorize((Resource)ArgumentMatchers.any(MenuItem.class), (User)ArgumentMatchers.any())).thenReturn((Object)true);
        ArrayList items = new ArrayList();
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(SECOND_PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        items.add(((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)NAME).perspective(THIRD_PERSPECTIVE_ID)).endMenu()).build().getItems().get(0));
        Menus menus = ((MenuFactory.Builder)MenuFactory.newSimpleItem((String)NAME).withItems(items).endMenu()).build();
        Mockito.when((Object)this.experimentalActivitiesAuthorizationManager.authorizeActivityId(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> !SECOND_PERSPECTIVE_ID.equals(invocationOnMock.getArguments()[0]));
        this.presenter.addMenus(menus);
        ((ExperimentalActivitiesAuthorizationManager)Mockito.verify((Object)this.experimentalActivitiesAuthorizationManager, (VerificationMode)Mockito.times((int)3))).authorizeActivityId(ArgumentMatchers.anyString());
        ((Map)Mockito.verify((Object)this.presenter.canHideMenuItemByIdentifier, (VerificationMode)Mockito.times((int)3))).put(ArgumentMatchers.any(), ArgumentMatchers.any());
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(PERSPECTIVE_ID), (VerificationMode)Mockito.times((int)2))).show();
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(SECOND_PERSPECTIVE_ID))).hide();
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(THIRD_PERSPECTIVE_ID), (VerificationMode)Mockito.times((int)2))).show();
    }

    @Test
    public void testShowHideExperimentalPerspectiveMenus() {
        this.testAddMenusWithExperimentalPerspective();
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(PERSPECTIVE_ID, false));
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(PERSPECTIVE_ID), (VerificationMode)Mockito.times((int)2))).hide();
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(SECOND_PERSPECTIVE_ID, true));
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(SECOND_PERSPECTIVE_ID), (VerificationMode)Mockito.times((int)3))).show();
        this.presenter.onPerspectiveVisibilityChange(new PerspectiveVisibiltiyChangeEvent(THIRD_PERSPECTIVE_ID, false));
        ((CanHide)Mockito.verify(this.presenter.canHideMenuItemByIdentifier.get(PERSPECTIVE_ID), (VerificationMode)Mockito.times((int)3))).hide();
    }

    class MegaMenuBrandMock
    implements MegaMenuBrand {
        private String brandImageUrl;
        private String brandImageLabel;
        private String menuAccessorLabel;

        public MegaMenuBrandMock(String brandImageUrl, String brandImageLabel, String menuAccessorLabel) {
            this.brandImageUrl = brandImageUrl;
            this.brandImageLabel = brandImageLabel;
            this.menuAccessorLabel = menuAccessorLabel;
        }

        public String brandImageUrl() {
            return this.brandImageUrl;
        }

        public String brandImageLabel() {
            return this.brandImageLabel;
        }

        public String menuAccessorLabel() {
            return this.menuAccessorLabel;
        }
    }
}

