/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.workbench.BeanFactory;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManagerImpl;
import org.uberfire.client.workbench.events.PanelFocusEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.StaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.CustomPanelDefinition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class PanelManagerTest {
    @Mock
    BeanFactory beanFactory;
    @Mock
    StubPlaceGainFocusEvent placeGainFocusEvent;
    @Mock
    StubPlaceLostFocusEvent placeLostFocusEvent;
    @Mock
    StubSelectPlaceEvent selectPlaceEvent;
    @Mock
    StubPanelFocusEvent panelFocusEvent;
    @Mock
    StubPlaceMaximizedEvent placeMaximizedEvent;
    @Mock
    StubPlaceMinimizedEvent placeMinimizedEvent;
    @Mock
    StubPlaceHiddenEvent placeHidEvent;
    @Mock
    SimpleWorkbenchPanelPresenter workbenchPanelPresenter;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    LayoutSelection layoutSelection;
    @Mock
    Elemental2DomUtil elemental2DomUtil;
    private PanelManagerImpl panelManager;
    private WorkbenchPartPresenter partPresenter;
    private PerspectiveDefinition testPerspectiveDef;
    private WorkbenchPanelPresenter testPerspectiveRootPanelPresenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.layoutSelection.get().getPerspectiveContainer()).thenReturn(Mockito.mock(HasWidgets.class));
        this.testPerspectiveDef = new PerspectiveDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        this.testPerspectiveRootPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class);
        Mockito.when((Object)this.beanFactory.newRootPanel((PerspectiveActivity)ArgumentMatchers.any(), (PanelDefinition)ArgumentMatchers.eq((Object)this.testPerspectiveDef.getRoot()))).thenReturn((Object)this.testPerspectiveRootPanelPresenter);
        Mockito.when((Object)this.testPerspectiveRootPanelPresenter.getDefinition()).thenReturn((Object)this.testPerspectiveDef.getRoot());
        Mockito.when((Object)this.testPerspectiveRootPanelPresenter.getPanelView()).thenReturn(Mockito.mock(WorkbenchPanelView.class));
        Mockito.when((Object)this.testPerspectiveRootPanelPresenter.getDefaultChildType()).thenReturn((Object)SimpleWorkbenchPanelPresenter.class.getName());
        this.partPresenter = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)this.beanFactory.newWorkbenchPart((Menus)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (IsWidget)ArgumentMatchers.any(), (PartDefinition)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenReturn((Object)this.partPresenter);
        Mockito.when((Object)this.beanFactory.newWorkbenchPanel((PanelDefinition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<WorkbenchPanelPresenter>(){

            public WorkbenchPanelPresenter answer(InvocationOnMock invocation) throws Throwable {
                WorkbenchPanelPresenter newPanelPresenter = (WorkbenchPanelPresenter)Mockito.mock(WorkbenchPanelPresenter.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
                Mockito.when((Object)newPanelPresenter.getDefinition()).thenReturn((Object)((PanelDefinition)invocation.getArguments()[0]));
                return newPanelPresenter;
            }
        });
        PerspectiveActivity testPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        this.panelManager = (PanelManagerImpl)Mockito.spy((Object)new PanelManagerImpl((Event)this.placeGainFocusEvent, (Event)this.placeLostFocusEvent, (Event)this.panelFocusEvent, (Event)this.selectPlaceEvent, (Event)this.placeMaximizedEvent, (Event)this.placeMinimizedEvent, (Event)this.placeHidEvent, null, null, this.layoutSelection, this.beanFactory, this.elemental2DomUtil));
        this.panelManager.setRoot(testPerspectiveActivity, this.testPerspectiveDef.getRoot());
        ((PanelManagerImpl)Mockito.doNothing().when((Object)this.panelManager)).appendWidgetToElement((HTMLElement)ArgumentMatchers.any(HTMLElement.class), (Widget)ArgumentMatchers.any(Widget.class));
    }

    @Test
    public void addPartToRootPanelShouldWork() throws Exception {
        DefaultPlaceRequest rootPartPlace = new DefaultPlaceRequest("rootPartPlace");
        PartDefinitionImpl rootPart = new PartDefinitionImpl((PlaceRequest)rootPartPlace);
        Menus rootPartMenus = ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newContributedMenu((String)"RootPartMenu").endMenu()).build();
        UIPart rootUiPart = new UIPart("RootUiPart", null, (IsWidget)Mockito.mock(IsWidget.class));
        this.panelManager.addWorkbenchPart((PlaceRequest)rootPartPlace, (PartDefinition)rootPart, this.panelManager.getRoot(), rootPartMenus, rootUiPart, "rootContextId", Integer.valueOf(100), Integer.valueOf(200));
        ((WorkbenchPartPresenter)Mockito.verify((Object)this.partPresenter)).setWrappedWidget(rootUiPart.getWidget());
        ((WorkbenchPartPresenter)Mockito.verify((Object)this.partPresenter)).setContextId("rootContextId");
        Assert.assertEquals((Object)rootPart, (Object)this.panelManager.getPartForPlace((PlaceRequest)rootPartPlace));
        ((StubSelectPlaceEvent)Mockito.verify((Object)this.selectPlaceEvent)).fire(ArgumentMatchers.refEq((Object)new SelectPlaceEvent((PlaceRequest)rootPartPlace), (String[])new String[0]));
        Assert.assertEquals(null, (Object)rootPart.getParentPanel());
        Assert.assertFalse((boolean)this.panelManager.getRoot().getParts().contains(rootPart));
    }

    @Test
    public void addPartToUnknownPanelShouldFail() throws Exception {
        DefaultPlaceRequest partPlace = new DefaultPlaceRequest("partPlace");
        PartDefinitionImpl part = new PartDefinitionImpl((PlaceRequest)partPlace);
        Menus partMenus = ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newContributedMenu((String)"PartMenu").endMenu()).build();
        UIPart uiPart = new UIPart("uiPart", null, (IsWidget)Mockito.mock(IsWidget.class));
        PanelDefinitionImpl randomUnattachedPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        try {
            this.panelManager.addWorkbenchPart((PlaceRequest)partPlace, (PartDefinition)part, (PanelDefinition)randomUnattachedPanel, partMenus, uiPart, "contextId", null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Target panel is not part of the layout", (Object)e.getMessage());
        }
        ((WorkbenchPartPresenter)Mockito.verify((Object)this.partPresenter, (VerificationMode)Mockito.never())).setWrappedWidget(uiPart.getWidget());
        ((WorkbenchPartPresenter)Mockito.verify((Object)this.partPresenter, (VerificationMode)Mockito.never())).setContextId("rootContextId");
        Assert.assertEquals(null, (Object)this.panelManager.getPartForPlace((PlaceRequest)partPlace));
        ((StubSelectPlaceEvent)Mockito.verify((Object)this.selectPlaceEvent, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.refEq((Object)new SelectPlaceEvent((PlaceRequest)partPlace), (String[])new String[0]));
    }

    @Test
    public void removingLastPartFromRootPanelShouldLeaveRootPanel() throws Exception {
        DefaultPlaceRequest rootPartPlace = new DefaultPlaceRequest("rootPartPlace");
        PartDefinitionImpl rootPart = new PartDefinitionImpl((PlaceRequest)rootPartPlace);
        Menus rootPartMenus = ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newContributedMenu((String)"RootPartMenu").endMenu()).build();
        UIPart rootUiPart = new UIPart("RootUiPart", null, (IsWidget)Mockito.mock(IsWidget.class));
        this.panelManager.addWorkbenchPart((PlaceRequest)rootPartPlace, (PartDefinition)rootPart, this.panelManager.getRoot(), rootPartMenus, rootUiPart, "rootContextId", null, null);
        this.panelManager.removePartForPlace((PlaceRequest)rootPartPlace);
        Assert.assertEquals(null, (Object)this.panelManager.getPartForPlace((PlaceRequest)rootPartPlace));
        ((BeanFactory)Mockito.verify((Object)this.beanFactory)).destroy((Object)this.partPresenter);
        ((BeanFactory)Mockito.verify((Object)this.beanFactory, (VerificationMode)Mockito.never())).destroy((Object)this.testPerspectiveRootPanelPresenter);
    }

    @Test
    public void addPanelAtRootPositionShouldReturnRootPanel() throws Exception {
        Mockito.when((Object)this.beanFactory.newRootPanel((PerspectiveActivity)ArgumentMatchers.any(PerspectiveActivity.class), (PanelDefinition)ArgumentMatchers.eq((Object)this.testPerspectiveDef.getRoot()))).thenReturn((Object)this.testPerspectiveRootPanelPresenter);
        Mockito.when((Object)this.testPerspectiveRootPanelPresenter.getDefaultChildType()).thenReturn(null);
        PerspectiveActivity testPerspectiveActivity = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        this.panelManager.setRoot(testPerspectiveActivity, this.testPerspectiveDef.getRoot());
        PanelDefinitionImpl notActuallyAdded = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinition result = this.panelManager.addWorkbenchPanel(this.testPerspectiveDef.getRoot(), (PanelDefinition)notActuallyAdded, (Position)CompassPosition.ROOT);
        Assert.assertSame((Object)result, (Object)this.testPerspectiveDef.getRoot());
    }

    @Test
    public void addedPanelsShouldBeRemembered() throws Exception {
        PanelDefinitionImpl subPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        this.testPerspectiveDef.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)subPanel);
        this.panelManager.addWorkbenchPanel(this.panelManager.getRoot(), (PanelDefinition)subPanel, (Position)CompassPosition.WEST);
        Assert.assertTrue((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(subPanel));
    }

    @Test
    public void addedCustomPanelsShouldBeRemembered() throws Exception {
        HasWidgets container = (HasWidgets)Mockito.mock(HasWidgets.class);
        CustomPanelDefinition customPanel = this.panelManager.addCustomPanel(container, StaticWorkbenchPanelPresenter.class.getName());
        Assert.assertTrue((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(customPanel));
    }

    @Test
    public void addedCustomPanelsInsideHTMLElementsShouldBeRemembered() throws Exception {
        HTMLElement container = (HTMLElement)Mockito.mock(HTMLElement.class);
        CustomPanelDefinition customPanel = this.panelManager.addCustomPanel(container, StaticWorkbenchPanelPresenter.class.getName());
        Assert.assertTrue((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(customPanel));
    }

    @Test
    public void explicitlyRemovedPanelsShouldBeForgotten() throws Exception {
        PanelDefinitionImpl subPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        this.testPerspectiveDef.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)subPanel);
        this.panelManager.addWorkbenchPanel(this.panelManager.getRoot(), (PanelDefinition)subPanel, (Position)CompassPosition.WEST);
        this.panelManager.removeWorkbenchPanel((PanelDefinition)subPanel);
        Assert.assertFalse((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(subPanel));
    }

    @Test
    public void explicitlyRemovedCustomPanelsShouldBeForgotten() throws Exception {
        HasWidgets container = (HasWidgets)Mockito.mock(HasWidgets.class);
        CustomPanelDefinition customPanel = this.panelManager.addCustomPanel(container, StaticWorkbenchPanelPresenter.class.getName());
        this.panelManager.removeWorkbenchPanel((PanelDefinition)customPanel);
        Assert.assertFalse((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(customPanel));
    }

    @Test
    public void explicitlyRemovedCustomPanelsInsideHTMLElementsShouldBeForgotten() throws Exception {
        HTMLElement container = (HTMLElement)Mockito.mock(HTMLElement.class);
        CustomPanelDefinition customPanel = this.panelManager.addCustomPanel(container, StaticWorkbenchPanelPresenter.class.getName());
        this.panelManager.removeWorkbenchPanel((PanelDefinition)customPanel);
        Assert.assertFalse((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(customPanel));
    }

    @Test
    public void explicitlyRemovedCustomPanelsInsideElemental2HTMLElementsShouldBeForgotten() {
        elemental2.dom.HTMLElement container = (elemental2.dom.HTMLElement)Mockito.mock(elemental2.dom.HTMLElement.class);
        CustomPanelDefinition customPanel = this.panelManager.addCustomPanel(container, StaticWorkbenchPanelPresenter.class.getName());
        this.panelManager.removeWorkbenchPanel((PanelDefinition)customPanel);
        Assert.assertFalse((boolean)this.panelManager.mapPanelDefinitionToPresenter.containsKey(customPanel));
    }

    @Test
    public void explicitlyRemovingRootPanelShouldFail() throws Exception {
        try {
            this.panelManager.removeWorkbenchPanel(this.testPerspectiveDef.getRoot());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("root"));
        }
    }

    @Test
    public void onSelectPlaceEventFocusesCorrectPresenter() throws Exception {
        PanelDefinitionImpl p1 = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PartDefinitionImpl pd1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest());
        p1.addPart((PartDefinition)pd1);
        this.testPerspectiveDef.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)p1);
        this.panelManager.addWorkbenchPanel(this.panelManager.getRoot(), (PanelDefinition)p1, (Position)CompassPosition.WEST);
        PanelDefinitionImpl p2 = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PartDefinitionImpl pd2 = new PartDefinitionImpl((PlaceRequest)new PathPlaceRequest());
        p2.addPart((PartDefinition)pd2);
        this.testPerspectiveDef.getRoot().appendChild((Position)CompassPosition.EAST, (PanelDefinition)p2);
        this.panelManager.addWorkbenchPanel(this.panelManager.getRoot(), (PanelDefinition)p2, (Position)CompassPosition.EAST);
        SelectPlaceEvent event = new SelectPlaceEvent((PlaceRequest)new PathPlaceRequest());
        this.panelManager.onSelectPlaceEvent(event);
        WorkbenchPanelPresenter partPresenter = (WorkbenchPanelPresenter)this.panelManager.mapPanelDefinitionToPresenter.get(p2);
        ((WorkbenchPanelPresenter)Mockito.verify((Object)partPresenter, (VerificationMode)Mockito.times((int)2))).setFocus(true);
    }

    static class StubPlaceHiddenEvent
    extends StubEventSource<PlaceHiddenEvent> {
        StubPlaceHiddenEvent() {
        }
    }

    static class StubPlaceMinimizedEvent
    extends StubEventSource<PlaceMinimizedEvent> {
        StubPlaceMinimizedEvent() {
        }
    }

    static class StubPlaceMaximizedEvent
    extends StubEventSource<PlaceMaximizedEvent> {
        StubPlaceMaximizedEvent() {
        }
    }

    static class StubPanelFocusEvent
    extends StubEventSource<PanelFocusEvent> {
        StubPanelFocusEvent() {
        }
    }

    static class StubSelectPlaceEvent
    extends StubEventSource<SelectPlaceEvent> {
        StubSelectPlaceEvent() {
        }
    }

    static class StubPlaceLostFocusEvent
    extends StubEventSource<PlaceLostFocusEvent> {
        StubPlaceLostFocusEvent() {
        }
    }

    static class StubPlaceGainFocusEvent
    extends StubEventSource<PlaceGainFocusEvent> {
        StubPlaceGainFocusEvent() {
        }
    }

    static class StubEventSource<T>
    implements Event<T> {
        StubEventSource() {
        }

        public void fire(T event) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Event<T> select(Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

