/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.dnd;

import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.workbench.BeanFactory;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragContext;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;

@ApplicationScoped
public class WorkbenchDragAndDropManager {
    Map<WorkbenchPanelView, DropController> dropControllerMap = new HashMap<WorkbenchPanelView, DropController>();
    @Inject
    WorkbenchPickupDragController dragController;
    @Inject
    BeanFactory factory;
    private WorkbenchDragContext workbenchContext = null;

    public void makeDraggable(IsWidget draggable, IsWidget dragHandle) {
        this.dragController.makeDraggable(draggable.asWidget(), dragHandle.asWidget());
    }

    public void registerDropController(WorkbenchPanelView owner, DropController dropController) {
        this.dropControllerMap.put(owner, dropController);
        this.dragController.registerDropController(dropController);
    }

    public void unregisterDropController(WorkbenchPanelView view) {
        DropController dropController = this.dropControllerMap.remove(view);
        this.dragController.unregisterDropController(dropController);
        this.factory.destroy(dropController);
    }

    public void unregisterDropControllers() {
        for (Map.Entry<WorkbenchPanelView, DropController> e : this.dropControllerMap.entrySet()) {
            DropController dropController = this.dropControllerMap.get(e.getKey());
            this.dragController.unregisterDropController(dropController);
            this.factory.destroy(dropController);
        }
        this.dropControllerMap.clear();
    }

    public WorkbenchDragContext getWorkbenchContext() {
        return this.workbenchContext;
    }

    public void setWorkbenchContext(WorkbenchDragContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }
}

