/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.dnd;

import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.BeanFactory;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManagerUnitTestWrapper;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;

@RunWith(value=GwtMockitoTestRunner.class)
public class WorkbenchDragAndDropManagerTest {
    private WorkbenchDragAndDropManagerUnitTestWrapper wrapper;
    @GwtMock
    private WorkbenchPanelView workbenchPanelView;
    @GwtMock
    private WorkbenchPickupDragController dragController;
    @GwtMock
    private DropController dropController;
    @GwtMock
    private BeanFactory factory;

    @Before
    public void setup() {
        this.wrapper = new WorkbenchDragAndDropManagerUnitTestWrapper();
        this.wrapper.setupMocks(this.dragController, this.factory);
    }

    @Test
    public void assertMakeDraggableDelegation() {
        this.wrapper.makeDraggable((IsWidget)Mockito.mock(IsWidget.class), (IsWidget)Mockito.mock(IsWidget.class));
        ((WorkbenchPickupDragController)Mockito.verify((Object)this.dragController)).makeDraggable((Widget)Mockito.any(), (Widget)Mockito.any());
    }

    @Test
    public void registerAndUnregisterDropController() {
        this.wrapper.registerDropController(this.workbenchPanelView, this.dropController);
        Assert.assertEquals(this.wrapper.dropControllerMap.get(this.workbenchPanelView), (Object)this.dropController);
        ((WorkbenchPickupDragController)Mockito.verify((Object)this.dragController)).registerDropController(this.dropController);
        this.wrapper.unregisterDropController(this.workbenchPanelView);
        ((WorkbenchPickupDragController)Mockito.verify((Object)this.dragController)).unregisterDropController(this.dropController);
        ((BeanFactory)Mockito.verify((Object)this.factory)).destroy((Object)this.dropController);
    }

    @Test
    public void registerAndUnregisterDropControllers() {
        this.wrapper.registerDropController(this.workbenchPanelView, this.dropController);
        Assert.assertEquals(this.wrapper.dropControllerMap.get(this.workbenchPanelView), (Object)this.dropController);
        WorkbenchPanelView workbenchPanelView2 = (WorkbenchPanelView)GWT.create(WorkbenchPanelView.class);
        DropController dropController2 = (DropController)GWT.create(DropController.class);
        this.wrapper.registerDropController(workbenchPanelView2, dropController2);
        Assert.assertEquals(this.wrapper.dropControllerMap.get(workbenchPanelView2), (Object)dropController2);
        this.wrapper.unregisterDropControllers();
        ((BeanFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).destroy((Object)this.dropController);
        ((BeanFactory)Mockito.verify((Object)this.factory, (VerificationMode)Mockito.times((int)1))).destroy((Object)dropController2);
        ((WorkbenchPickupDragController)Mockito.verify((Object)this.dragController)).unregisterDropController(this.dropController);
        ((WorkbenchPickupDragController)Mockito.verify((Object)this.dragController)).unregisterDropController(dropController2);
        Assert.assertTrue((boolean)this.wrapper.dropControllerMap.isEmpty());
    }
}

