/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.docks;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwtmockito.GwtMockitoTestRunner;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireDockTest
extends TestCase {
    private static final UberfireDockPosition DOCK_POSITION = UberfireDockPosition.EAST;
    private static String ICON_TYPE = "ICON_TYPE";
    private static final String SCREEN_ID = "SCREEN_ID";
    private static final String PERSPECTIVE_ID = "PERSPECTIVE_ID";
    private static final int SIZE = 450;
    private static final String LABEL = "DOCK TITLE";
    private static final String TOOLTIP = "DOCK TOOLTIP";
    @Mock
    private ImageResource imageIcon1;
    @Mock
    private ImageResource imageIcon2;
    @Mock
    private ImageResource imageIconFocused1;
    @Mock
    private ImageResource imageIconFocused2;
    private UberfireDock tested;
    private UberfireDock testedWithImages;

    @Before
    public void setUp() {
        this.tested = new UberfireDock(DOCK_POSITION, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withLabel(LABEL).withTooltip(TOOLTIP).withSize(450.0);
        this.testedWithImages = new UberfireDock(DOCK_POSITION, this.imageIcon1, this.imageIconFocused1, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID);
    }

    @Test
    public void testWithLabel() {
        UberfireDockTest.assertEquals((int)0, (int)this.tested.getLabel().compareTo(LABEL));
    }

    @Test
    public void testWithTooltip() {
        UberfireDockTest.assertEquals((int)0, (int)this.tested.getTooltip().compareTo(TOOLTIP));
        UberfireDock tested2 = new UberfireDock(UberfireDockPosition.EAST, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID);
        UberfireDockTest.assertNull((Object)tested2.getTooltip());
    }

    @Test
    public void testWithSize() {
        UberfireDockTest.assertEquals((double)450.0, (double)this.tested.getSize(), (double)0.0);
    }

    @Test
    public void testSetUberfireDockPosition() {
        UberfireDock uberfireDock = this.tested = new UberfireDock(UberfireDockPosition.EAST, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID);
        uberfireDock.setUberfireDockPosition(UberfireDockPosition.WEST);
        UberfireDockTest.assertEquals((Object)UberfireDockPosition.WEST, (Object)this.tested.getDockPosition());
    }

    @Test
    public void testGetAssociatedPerspective() {
        UberfireDockTest.assertEquals((String)PERSPECTIVE_ID, (String)this.tested.getAssociatedPerspective());
    }

    @Test
    public void testGetIdentifier() {
        UberfireDockTest.assertEquals((String)SCREEN_ID, (String)this.tested.getIdentifier());
    }

    @Test
    public void testGetPlaceRequest() {
        UberfireDockTest.assertEquals((String)SCREEN_ID, (String)this.tested.getPlaceRequest().getIdentifier());
    }

    @Test
    public void testGetDockPosition() {
        UberfireDockTest.assertEquals((Object)DOCK_POSITION, (Object)this.tested.getDockPosition());
    }

    @Test
    public void testGetSize() {
        UberfireDockTest.assertEquals((double)450.0, (double)this.tested.getSize(), (double)0.0);
    }

    @Test
    public void testGetLabel() {
        UberfireDockTest.assertEquals((String)LABEL, (String)this.tested.getLabel());
    }

    @Test
    public void testGetTooltip() {
        UberfireDockTest.assertEquals((String)TOOLTIP, (String)this.tested.getTooltip());
    }

    @Test
    public void testGetIconType() {
        UberfireDockTest.assertEquals((String)ICON_TYPE, (String)this.tested.getIconType());
    }

    @Test
    public void testGetImageIcon() {
        UberfireDockTest.assertEquals((Object)this.imageIcon1, (Object)this.testedWithImages.getImageIcon());
    }

    @Test
    public void testGetImageIconFocused() {
        UberfireDockTest.assertEquals((Object)this.imageIconFocused1, (Object)this.testedWithImages.getImageIconFocused());
    }

    @Test
    public void testEquals() {
        UberfireDock compareDock1 = new UberfireDock(DOCK_POSITION, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withSize(450.0).withLabel(LABEL).withTooltip(TOOLTIP);
        UberfireDock compareDock2 = new UberfireDock(DOCK_POSITION, this.imageIcon1, this.imageIconFocused1, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withSize(450.0).withLabel(LABEL).withTooltip(TOOLTIP);
        UberfireDock compareDock3 = new UberfireDock(null, null, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID));
        UberfireDock compareDock4 = new UberfireDock(null, null, null, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID));
        UberfireDock compareDock5 = new UberfireDock(UberfireDockPosition.WEST, ICON_TYPE + "EXTRA", (PlaceRequest)new DefaultPlaceRequest("SCREEN_IDEXTRA"), "PERSPECTIVE_IDEXTRA").withSize(470.0).withLabel("DOCK TITLEEXTRA").withTooltip("DOCK TOOLTIPEXTRA");
        UberfireDock compareDock6 = new UberfireDock(UberfireDockPosition.WEST, this.imageIcon2, this.imageIconFocused2, (PlaceRequest)new DefaultPlaceRequest("SCREEN_IDEXTRA"), "PERSPECTIVE_IDEXTRA").withSize(470.0).withLabel("DOCK TITLEEXTRA").withTooltip("DOCK TOOLTIPEXTRA");
        UberfireDockTest.assertEquals((Object)this.tested, (Object)this.tested);
        UberfireDockTest.assertEquals((Object)this.tested, (Object)compareDock1);
        Assert.assertNotEquals(null, (Object)this.tested);
        Assert.assertNotEquals((Object)this.tested, (Object)new Object());
        Assert.assertNotEquals((Object)this.tested, (Object)compareDock2);
        Assert.assertNotEquals((Object)this.tested, (Object)compareDock3);
        Assert.assertNotEquals((Object)this.tested, (Object)compareDock4);
        Assert.assertNotEquals((Object)this.tested, (Object)compareDock5);
        Assert.assertNotEquals((Object)this.tested, (Object)compareDock6);
        Assert.assertNotEquals((Object)compareDock1, (Object)compareDock2);
        Assert.assertNotEquals((Object)compareDock1, (Object)compareDock3);
        Assert.assertNotEquals((Object)compareDock1, (Object)compareDock4);
        Assert.assertNotEquals((Object)compareDock1, (Object)compareDock5);
        Assert.assertNotEquals((Object)compareDock1, (Object)compareDock6);
        Assert.assertNotEquals((Object)compareDock2, (Object)compareDock3);
        Assert.assertNotEquals((Object)compareDock2, (Object)compareDock4);
        Assert.assertNotEquals((Object)compareDock2, (Object)compareDock5);
        Assert.assertNotEquals((Object)compareDock2, (Object)compareDock6);
        UberfireDockTest.assertEquals((Object)compareDock3, (Object)compareDock4);
        Assert.assertNotEquals((Object)compareDock3, (Object)compareDock5);
        Assert.assertNotEquals((Object)compareDock3, (Object)compareDock6);
        Assert.assertNotEquals((Object)compareDock4, (Object)compareDock5);
        Assert.assertNotEquals((Object)compareDock4, (Object)compareDock6);
        Assert.assertNotEquals((Object)compareDock5, (Object)compareDock6);
    }

    @Test
    public void testTestHashCode() {
        UberfireDock compareDock1 = new UberfireDock(DOCK_POSITION, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withSize(450.0).withLabel(LABEL).withTooltip(TOOLTIP);
        UberfireDock compareDock2 = new UberfireDock(DOCK_POSITION, this.imageIcon1, this.imageIconFocused1, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withSize(450.0).withLabel(LABEL).withTooltip(TOOLTIP);
        UberfireDock compareDock3 = new UberfireDock(null, null, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID));
        UberfireDock compareDock4 = new UberfireDock(null, null, null, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID));
        UberfireDock compareDock5 = new UberfireDock(DOCK_POSITION, ICON_TYPE, (PlaceRequest)new DefaultPlaceRequest(SCREEN_ID), PERSPECTIVE_ID).withLabel(null);
        UberfireDockTest.assertEquals((int)this.tested.hashCode(), (int)compareDock1.hashCode());
        UberfireDockTest.assertNotSame((Object)this.tested.hashCode(), (Object)compareDock2.hashCode());
        UberfireDockTest.assertNotSame((Object)this.tested.hashCode(), (Object)compareDock3.hashCode());
        UberfireDockTest.assertNotSame((Object)this.tested.hashCode(), (Object)compareDock4.hashCode());
        UberfireDockTest.assertNotSame((Object)this.tested.hashCode(), (Object)compareDock5.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock1.hashCode(), (Object)compareDock2.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock1.hashCode(), (Object)compareDock3.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock1.hashCode(), (Object)compareDock4.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock1.hashCode(), (Object)compareDock5.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock2.hashCode(), (Object)compareDock3.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock2.hashCode(), (Object)compareDock4.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock2.hashCode(), (Object)compareDock5.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock3.hashCode(), (Object)compareDock4.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock3.hashCode(), (Object)compareDock5.hashCode());
        UberfireDockTest.assertNotSame((Object)compareDock4.hashCode(), (Object)compareDock5.hashCode());
    }
}

