/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Collection;
import java.util.List;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.workbench.type.ClientResourceType;

public class ActivityAndMetaInfo {
    private SyncBeanManager iocManager;
    private final SyncBeanDef<Activity> activityBean;
    private final int priority;
    final List<String> resourceTypesNames;
    ClientResourceType[] resourceTypes;

    ActivityAndMetaInfo(SyncBeanManager iocManager, SyncBeanDef<Activity> activityBean, int priority, List<String> resourceTypesNames) {
        this.iocManager = iocManager;
        this.activityBean = activityBean;
        this.priority = priority;
        this.resourceTypesNames = resourceTypesNames;
    }

    public SyncBeanDef<Activity> getActivityBean() {
        return this.activityBean;
    }

    public int getPriority() {
        return this.priority;
    }

    public ClientResourceType[] getResourceTypes() {
        if (this.resourceTypes == null) {
            this.dynamicLookupResourceTypes();
        }
        return this.resourceTypes;
    }

    private void dynamicLookupResourceTypes() {
        this.resourceTypes = new ClientResourceType[this.resourceTypesNames.size()];
        for (int i = 0; i < this.resourceTypesNames.size(); ++i) {
            String resourceTypeIdentifier = this.resourceTypesNames.get(i);
            Collection resourceTypeBeans = this.iocManager.lookupBeans(resourceTypeIdentifier);
            if (resourceTypeBeans.isEmpty()) {
                throw new RuntimeException("ClientResourceType " + resourceTypeIdentifier + " not found");
            }
            this.resourceTypes[i] = (ClientResourceType)((SyncBeanDef)resourceTypeBeans.iterator().next()).getInstance();
        }
    }
}

