/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.impl.SimpleDnDWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleDnDWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.SinglePartPanelHelper;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;

@RunWith(value=GwtMockitoTestRunner.class)
public class SimpleDnDWorkbenchPanelPresenterTest {
    @Mock
    SimpleDnDWorkbenchPanelView view;
    SimpleDnDWorkbenchPanelPresenter presenter;
    @Mock
    private PlaceManager placeManager;

    @Test
    public void addPartTest() {
        this.presenter = new SimpleDnDWorkbenchPanelPresenter(this.view, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.placeManager);
        this.presenter.init();
        this.presenter.setDefinition((PanelDefinition)new PanelDefinitionImpl());
        WorkbenchPartPresenter part = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part.getDefinition()).thenReturn((Object)((PartDefinition)Mockito.mock(PartDefinition.class)));
        this.presenter.addPart(part);
        ((SimpleDnDWorkbenchPanelView)Mockito.verify((Object)this.view)).addPart((WorkbenchPartPresenter.View)ArgumentMatchers.any());
    }

    @Test
    public void addPartTwiceShouldCloseOtherPartTest() {
        final SinglePartPanelHelper singlePartPanelHelper = (SinglePartPanelHelper)Mockito.mock(SinglePartPanelHelper.class);
        this.presenter = new SimpleDnDWorkbenchPanelPresenter(this.view, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.placeManager){

            SinglePartPanelHelper createSinglePartPanelHelper() {
                return singlePartPanelHelper;
            }
        };
        this.presenter.init();
        this.presenter.setDefinition((PanelDefinition)new PanelDefinitionImpl());
        Mockito.when((Object)singlePartPanelHelper.hasNoParts()).thenReturn((Object)false);
        WorkbenchPartPresenter part2 = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part2.getDefinition()).thenReturn((Object)((PartDefinition)Mockito.mock(PartDefinition.class)));
        this.presenter.addPart(part2);
        ((SinglePartPanelHelper)Mockito.verify((Object)singlePartPanelHelper)).closeFirstPartAndAddNewOne((Command)ArgumentMatchers.any(Command.class));
    }
}

