/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.annotations.processors.AbstractErrorAbsorbingProcessor;
import org.uberfire.annotations.processors.AbstractGenerator;

public abstract class AbstractProcessorTest {
    private static final String SOURCE_FILETYPE = ".java";

    public List<Diagnostic<? extends JavaFileObject>> compile(Processor annotationProcessor, String ... compilationUnits) {
        DiagnosticCollector diagnosticListener = new DiagnosticCollector();
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticListener, null, null);
            String[] convertedCompilationUnits = this.convertCompilationUnitToFilePaths(compilationUnits);
            Iterable<? extends JavaFileObject> compilationUnitsJavaObjects = fileManager.getJavaFileObjects(convertedCompilationUnits);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticListener, null, null, compilationUnitsJavaObjects);
            task.setProcessors(Arrays.asList(annotationProcessor));
            task.call();
            fileManager.close();
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        return diagnosticListener.getDiagnostics();
    }

    private String[] convertCompilationUnitToFilePaths(String[] compilationUnits) {
        ArrayList<String> convertedCompilationUnits = new ArrayList<String>();
        for (String compilationUnit : compilationUnits) {
            convertedCompilationUnits.add(this.getClass().getResource("/" + compilationUnit + SOURCE_FILETYPE).getPath());
        }
        return convertedCompilationUnits.toArray(new String[convertedCompilationUnits.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExpectedSourceCode(String compilationUnit) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        try {
            String path = this.getClass().getResource("/" + compilationUnit).getPath();
            FileReader fr = new FileReader(path);
            try (BufferedReader input = new BufferedReader(fr);){
                String line = null;
                while ((line = input.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        return sb.toString();
    }

    public void assertSuccessfulCompilation(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        Assert.assertFalse((String)diagnostics.toString(), (boolean)this.hasErrors(diagnostics));
    }

    public void assertFailedCompilation(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        Assert.assertTrue((boolean)this.hasErrors(diagnostics));
    }

    private boolean hasErrors(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
            return true;
        }
        return false;
    }

    public void assertCompilationMessage(List<Diagnostic<? extends JavaFileObject>> diagnostics, Diagnostic.Kind kind, long line, long col, String message) {
        StringBuilder sb = new StringBuilder(100);
        for (Diagnostic<? extends JavaFileObject> msg : diagnostics) {
            sb.append((Object)msg.getKind()).append(" ").append(msg.getLineNumber()).append(":").append(msg.getColumnNumber()).append(": ").append(msg.getMessage(null)).append("\n");
            if (kind != null && !msg.getKind().equals((Object)kind) || line != -1L && msg.getLineNumber() != line || col != -1L && msg.getColumnNumber() != col || !msg.getMessage(null).contains(message)) continue;
            return;
        }
        Assert.fail((String)("Compiler diagnostics did not contain " + (Object)((Object)kind) + " message " + line + ":" + col + ": " + message + "\nDump of all " + diagnostics.size() + " actual messages:\n" + sb));
    }

    protected abstract AbstractErrorAbsorbingProcessor getProcessorUnderTest();

    @Test
    public void shouldNotAllowClassNotFoundExceptionThrough() throws Exception {
        AbstractErrorAbsorbingProcessor processorUnderTest = null;
        try {
            AbstractGenerator.FAIL_FOR_TESTING = true;
            processorUnderTest = this.getProcessorUnderTest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)"The annotation processor's constructor threw an exception. This is bad for Eclipse!");
        }
        finally {
            AbstractGenerator.FAIL_FOR_TESTING = false;
        }
        List<Diagnostic<? extends JavaFileObject>> messages = this.compile((Processor)processorUnderTest, "org/uberfire/annotations/processors/AnnotatedWithEverything");
        this.assertCompilationMessage(messages, Diagnostic.Kind.ERROR, -1L, -1L, "Failing for testing purposes");
    }

    public class Result {
        private String expectedCode;
        private String actualCode;

        public String getExpectedCode() {
            return this.expectedCode;
        }

        public void setExpectedCode(String expectedCode) {
            this.expectedCode = expectedCode;
        }

        public String getActualCode() {
            return this.actualCode;
        }

        public void setActualCode(String actualCode) {
            this.actualCode = actualCode;
        }
    }
}

