/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit;

import java.io.File;
import org.eclipse.jgit.lib.ObjectId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.fs.base.AbstractPath;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class JGitPathImpl
extends AbstractPath<JGitFileSystem> {
    public static final String DEFAULT_REF_TREE = "master";
    private final ObjectId objectId;

    private JGitPathImpl(JGitFileSystem fs, String path, String host, ObjectId id, boolean isRoot, boolean isRealPath, boolean isNormalized) {
        super((FileSystem)fs, path, host, isRoot, isRealPath, isNormalized);
        this.objectId = id;
    }

    protected AbstractPath.RootInfo setupRoot(JGitFileSystem fs, String pathx, String host, boolean isRoot) {
        boolean isRooted = isRoot ? true : pathx.startsWith("/");
        boolean isAbsolute = isRooted;
        int lastOffset = isAbsolute ? 1 : 0;
        boolean isFinalRoot = pathx.length() == 1 && lastOffset == 1 ? true : isRoot;
        return new AbstractPath.RootInfo(lastOffset, isAbsolute, isFinalRoot, pathx.getBytes());
    }

    protected String defaultDirectory() {
        return "/:";
    }

    protected Path newRoot(JGitFileSystem fs, String substring, String host, boolean realPath) {
        return new JGitPathImpl(fs, substring, host, null, true, realPath, true);
    }

    protected Path newPath(JGitFileSystem fs, String substring, String host, boolean isRealPath, boolean isNormalized) {
        return new JGitPathImpl(fs, substring, host, null, false, isRealPath, isNormalized);
    }

    public static JGitPathImpl create(JGitFileSystem fs, String path, String host, ObjectId id, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), id, false, isRealPath, false);
    }

    public static JGitPathImpl create(JGitFileSystem fs, String path, String host, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), null, false, isRealPath, false);
    }

    public static JGitPathImpl createRoot(JGitFileSystem fs, String path, String host, boolean isRealPath) {
        return new JGitPathImpl(fs, JGitPathImpl.setupPath(path), JGitPathImpl.setupHost(host), null, true, isRealPath, true);
    }

    public File toFile() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected BasicFileAttributes newAttrs() {
        return JGitUtil.buildBasicFileAttributes(((JGitFileSystem)this.getFileSystem()).gitRepo(), this.getRefTree(), this.getPath());
    }

    private static String setupHost(String host) {
        if (host.indexOf("@") == -1) {
            return "master@" + host;
        }
        return host;
    }

    private static String setupPath(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        return path;
    }

    public String getRefTree() {
        return this.host.substring(0, this.host.indexOf("@"));
    }

    public String getPath() {
        return new String(this.path);
    }
}

