/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility;

import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@RunWith(value=Arquillian.class)
public class BundleLifecycleTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"simple-bundle.jar");
        archive.addClasses(new Class[]{BundleLifecycleTest.class, Activator.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName("simple-bundle");
                builder.addBundleVersion("1.0.0");
                builder.addBundleActivator(Activator.class);
                builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                builder.addImportPackages(new Class[]{RuntimeLocator.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testModuleLifecycle() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module modA = runtime.getModule(this.getClass().getClassLoader());
        Assert.assertEquals((Object)Module.State.ACTIVE, (Object)modA.getState());
        String symbolicName = (String)modA.getHeaders().get("Bundle-SymbolicName");
        Assert.assertEquals((Object)"simple-bundle", (Object)symbolicName);
        ModuleContext context = modA.getModuleContext();
        Module sysmodule = runtime.getModule(0L);
        symbolicName = (String)sysmodule.getHeaders().get("Bundle-SymbolicName");
        Assert.assertNotNull((String)"System bundle symbolic name not null", (Object)symbolicName);
        ServiceReference sref = context.getServiceReference(String.class);
        String service = (String)context.getService(sref);
        Assert.assertEquals((Object)"Hello", (Object)service);
        modA.stop();
        Assert.assertEquals((Object)Module.State.INSTALLED, (Object)modA.getState());
        modA.uninstall();
        Assert.assertEquals((Object)Module.State.UNINSTALLED, (Object)modA.getState());
        try {
            modA.start();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class Activator
    implements BundleActivator {
        ServiceRegistration<String> sreg;

        public void start(BundleContext context) throws Exception {
            this.sreg = context.registerService(String.class, (Object)new String("Hello"), null);
        }

        public void stop(BundleContext context) throws Exception {
            this.sreg.unregister();
        }
    }
}

