/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.activemq;

import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.Component;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;

@Startup
@ApplicationScoped
@ContextName(value="amq-cdi-context")
public class ActiveMQRouteBuilder
extends RouteBuilder {
    public void configure() throws Exception {
        InitialContext context = new InitialContext();
        ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("java:/AMQConnectionFactory");
        ActiveMQComponent activeMQComponent = new ActiveMQComponent();
        activeMQComponent.setConnectionFactory(connectionFactory);
        this.getContext().addComponent("activemq", (Component)activeMQComponent);
        ((RouteDefinition)this.from("file://{{jboss.server.data.dir}}/orders").log("Receiving order for ${file:name}")).to("activemq:queue:testQueue");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("activemq:queue:testQueue").choice().when((Predicate)this.xpath("/order/customer/country = 'UK'")).log("Sending order ${file:name} to the UK")).to("file:{{jboss.server.data.dir}}/orders/processed/UK")).when((Predicate)this.xpath("/order/customer/country = 'US'")).log("Sending order ${file:name} to the US")).to("file:{{jboss.server.data.dir}}/orders/processed/US")).otherwise().log("Sending order ${file:name} to another country")).to("file://{{jboss.server.data.dir}}/orders/processed/Others");
    }
}

