/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.activemq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="HttpServiceServlet", urlPatterns={"/orders/*"}, loadOnStartup=1)
public class SimpleServlet
extends HttpServlet {
    private static final String[] COUNTRIES = new String[]{"UK", "US", "Others"};
    private static final Path ORDERS_PATH = new File(System.getProperty("jboss.server.data.dir")).toPath().resolve("orders");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        try {
            InputStream input = servletContext.getResourceAsStream("/WEB-INF/order.xml");
            Path xmlPath = ORDERS_PATH.resolve("order.xml");
            Files.copy(input, xmlPath, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, Integer> orderCounts = new HashMap<String, Integer>();
        for (String country : COUNTRIES) {
            int orderCount = this.countOrdersForCountry(country);
            if (orderCount <= 0) continue;
            orderCounts.put(country, orderCount);
        }
        request.setAttribute("orders", orderCounts);
        request.getRequestDispatcher("/WEB-INF/orders.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private int countOrdersForCountry(String country) throws IOException {
        Path countryPath = new File(System.getProperty("jboss.server.data.dir")).toPath().resolve("orders/processed/" + country);
        File file = countryPath.toFile();
        if (file.isDirectory()) {
            return file.list().length;
        }
        return 0;
    }
}

