/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jaxws;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ProxyBuilder;
import org.apache.camel.cdi.ContextName;
import org.wildfly.camel.examples.jaxws.GreetingService;

@WebService(serviceName="greeting", endpointInterface="org.wildfly.camel.examples.jaxws.GreetingService")
public class GreetingServiceImpl {
    @Inject
    @ContextName(value="jaxws-camel-context")
    private CamelContext context;
    private GreetingService greetingService;

    @PostConstruct
    public void initServiceProxy() throws Exception {
        this.greetingService = (GreetingService)new ProxyBuilder(this.context).endpoint("direct:start").binding(false).build(GreetingService.class);
    }

    @WebMethod(operationName="greet")
    public String greet(@WebParam(name="name") String name) {
        return this.greetingService.greet(name);
    }

    @WebMethod(operationName="greetWithMessage")
    public String greetWithMessage(@WebParam(name="message") String message, @WebParam(name="name") String name) {
        return this.greetingService.greetWithMessage(message, name);
    }
}

