/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms;

import javax.annotation.Resource;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.jms.ConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;

@Startup
@ApplicationScoped
@ContextName(value="jms-cdi-context")
public class JmsRouteBuilder
extends RouteBuilder {
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;

    public void configure() throws Exception {
        JmsComponent component = new JmsComponent();
        component.setConnectionFactory(this.connectionFactory);
        this.getContext().addComponent("jms", (Component)component);
        ((RouteDefinition)((RouteDefinition)this.from("file://{{jboss.server.data.dir}}/orders").convertBodyTo(String.class)).removeHeaders("*")).to("jms:queue:OrdersQueue");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("jms:queue:OrdersQueue").choice().when((Predicate)this.xpath("/order/customer/country = 'UK'")).log("Sending order ${file:name} to the UK")).to("file:{{jboss.server.data.dir}}/orders/processed/UK")).when((Predicate)this.xpath("/order/customer/country = 'US'")).log("Sending order ${file:name} to the US")).to("file:{{jboss.server.data.dir}}/orders/processed/US")).otherwise().log("Sending order ${file:name} to another country")).to("file://{{jboss.server.data.dir}}/orders/processed/others");
    }
}

