/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jpa;

import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.wildfly.camel.examples.jpa.model.Customer;

@Startup
@ApplicationScoped
@ContextName(value="jpa-cdi-context")
public class JpaRouteBuilder
extends RouteBuilder {
    @Inject
    private EntityManager em;
    @Inject
    UserTransaction userTransaction;

    public void configure() throws Exception {
        String vmname = System.getProperty("java.vm.name");
        if (vmname.contains("OpenJDK")) {
            return;
        }
        JaxbDataFormat jaxbDataFormat = new JaxbDataFormat();
        jaxbDataFormat.setContextPath(Customer.class.getPackage().getName());
        EntityManagerFactory entityManagerFactory = this.em.getEntityManagerFactory();
        JtaTransactionManager transactionManager = new JtaTransactionManager();
        transactionManager.setUserTransaction(this.userTransaction);
        transactionManager.afterPropertiesSet();
        JpaEndpoint jpaEndpoint = new JpaEndpoint();
        jpaEndpoint.setCamelContext((CamelContext)this.getContext());
        jpaEndpoint.setEntityType(Customer.class);
        jpaEndpoint.setEntityManagerFactory(entityManagerFactory);
        jpaEndpoint.setTransactionManager((PlatformTransactionManager)transactionManager);
        ((RouteDefinition)((RouteDefinition)this.from("file://{{jboss.server.data.dir}}/customers").unmarshal((DataFormatDefinition)jaxbDataFormat)).to((Endpoint)jpaEndpoint)).to("log:input?showAll=true");
    }
}

