/*
 * #%L
 * Wildfly Camel :: Example :: Camel JPA
 * %%
 * Copyright (C) 2013 - 2014 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.wildfly.camel.examples.jpa;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import javax.persistence.EntityManager;

import org.apache.camel.component.jpa.JpaComponent;
import org.springframework.transaction.PlatformTransactionManager;

public class JPAComponentProducer {

    @Produces
    @ApplicationScoped
    @Named("jpa")
    public JpaComponent jpaComponent(PlatformTransactionManager transactionManager, EntityManager entityManager) {
        JpaComponent component = new JpaComponent();
        component.setTransactionManager(transactionManager);
        component.setEntityManagerFactory(entityManager.getEntityManagerFactory());
        return component;
    }
}
