/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest.data;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Selection;
import org.wildfly.camel.examples.rest.model.Customer;

@Stateless
public class CustomerRepository {
    @PersistenceContext(unitName="camel")
    EntityManager em;

    public List<Customer> findAllCustomers() {
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Customer.class);
        query.select((Selection)query.from(Customer.class));
        return this.em.createQuery(query).getResultList();
    }

    public void createCustomer(Customer customer) {
        this.em.persist((Object)customer);
    }

    public Customer readCustomer(Long customerId) {
        return (Customer)this.em.find(Customer.class, (Object)customerId);
    }

    public void updateCustomer(Customer customer) {
        this.em.merge((Object)customer);
    }

    public void deleteCustomer(Long customerId) {
        Customer customer = (Customer)this.em.getReference(Customer.class, (Object)customerId);
        this.em.remove((Object)customer);
    }

    public void deleteCustomers() {
        this.em.createQuery("DELETE FROM Customer").executeUpdate();
    }
}

