/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.rest.jaxrs;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.ProxyBuilder;
import org.apache.camel.cdi.ContextName;
import org.wildfly.camel.examples.rest.jaxrs.CustomerService;
import org.wildfly.camel.examples.rest.model.Customer;

public class CustomerServiceImpl
implements CustomerService {
    @Inject
    @ContextName(value="rest-camel-context")
    private CamelContext context;
    private CustomerService customerServiceProxy;

    @PostConstruct
    public void initServiceProxy() throws Exception {
        this.customerServiceProxy = (CustomerService)new ProxyBuilder(this.context).endpoint("direct:rest").binding(false).build(CustomerService.class);
    }

    public Response getCustomers() {
        return this.customerServiceProxy.getCustomers();
    }

    public Response updateCustomer(Customer customer) {
        return this.customerServiceProxy.updateCustomer(customer);
    }

    public Response deleteCustomer(Long customerId) {
        return this.customerServiceProxy.deleteCustomer(customerId);
    }

    public Response deleteCustomers() {
        return this.customerServiceProxy.deleteCustomers();
    }
}

