/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.examples.jms.transacted;

import javax.annotation.Resource;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.persistence.EntityManager;
import org.apache.camel.Component;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.springframework.transaction.PlatformTransactionManager;
import org.wildfly.camel.examples.jms.transacted.JmsTransactionManager;
import org.wildfly.camel.examples.jms.transacted.model.Order;

@Startup
@ApplicationScoped
@ContextName(value="jms-camel-context")
public class JmsRouteBuilder
extends RouteBuilder {
    @Inject
    private EntityManager entityManager;
    @Inject
    private JmsTransactionManager transactionManager;
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory connectionFactory;

    public void configure() throws Exception {
        JmsComponent jmsComponent = JmsComponent.jmsComponentTransacted((ConnectionFactory)this.connectionFactory, (PlatformTransactionManager)this.transactionManager);
        this.getContext().addComponent("jms", (Component)jmsComponent);
        JpaComponent jpaComponent = new JpaComponent();
        jpaComponent.setEntityManagerFactory(this.entityManager.getEntityManagerFactory());
        jpaComponent.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        this.getContext().addComponent("jpa", (Component)jpaComponent);
        JaxbDataFormat jaxbDataFormat = new JaxbDataFormat();
        jaxbDataFormat.setContextPath(Order.class.getPackage().getName());
        ((OnExceptionDefinition)this.onException(IllegalStateException.class).maximumRedeliveries(1).handled(true).to("jms:queue:DLQ")).markRollbackOnly();
        this.from("file:{{jboss.server.data.dir}}/orders").transacted().to("jms:queue:OrdersQueue");
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("jms:queue:OrdersQueue").unmarshal((DataFormatDefinition)jaxbDataFormat)).to("jpa:Order")).choice().when((Predicate)this.simple("${body.quantity} > 10")).log("Order quantity is greater than 10 - rolling back transaction!")).throwException((Exception)new IllegalStateException())).otherwise().log("Order processed successfully");
    }
}

