/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.undertow;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.undertow.HttpServerEngine;
import org.apache.cxf.transport.undertow.HttpServerEngineFactory;
import org.apache.cxf.transport.undertow.UndertowHTTPHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;

public class UndertowHTTPDestination
extends ServletDestination
implements CamelEndpointDeploymentSchedulerService.EndpointHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowHTTPDestination.class);
    protected HttpServerEngine engine;
    protected HttpServerEngineFactory serverEngineFactory;
    protected URL nurl;
    protected ClassLoader loader;
    private boolean configFinalized;

    public UndertowHTTPDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei) throws IOException {
        super(bus, registry, ei, UndertowHTTPDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.serverEngineFactory = (HttpServerEngineFactory)bus.getExtension(HttpServerEngineFactory.class);
        if (this.serverEngineFactory != null) {
            this.nurl = new URL(this.getAddress(this.endpointInfo));
        }
        this.loader = (ClassLoader)bus.getExtension(ClassLoader.class);
    }

    public void retrieveEngine() throws GeneralSecurityException, IOException {
        CertificateConstraintsType constraints;
        if (this.serverEngineFactory == null) {
            return;
        }
        this.engine = this.serverEngineFactory.retrieveHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.getHTTPServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
        TLSServerParameters serverParameters = this.engine.getTlsServerParameters();
        if (serverParameters != null && serverParameters.getCertConstraints() != null && (constraints = serverParameters.getCertConstraints()) != null) {
            this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints((CertificateConstraintsType)constraints);
        }
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    public String getAddress(EndpointInfo endpointInfo) {
        return endpointInfo.getAddress();
    }

    public void activate() {
        super.activate();
        LOG.debug("Activating receipt of incoming messages");
        Class serviceClass = (Class)this.endpointInfo.getProperty("serviceClass", Class.class);
        if (serviceClass != null && this.loader == null) {
            ClassLoader cl = serviceClass.getClassLoader();
            LOG.debug("Using classloader {} obtained via endpointInfo serviceClass", (Object)cl);
            this.loader = cl;
        }
        if (this.engine != null) {
            UndertowHTTPHandler jhd = this.createJettyHTTPHandler(this, this.contextMatchOnExact());
            this.engine.addServant(this.nurl, jhd);
        }
    }

    public UndertowHTTPHandler createJettyHTTPHandler(UndertowHTTPDestination jhd, boolean cmExact) {
        return new UndertowHTTPHandler(jhd, cmExact);
    }

    public void deactivate() {
        super.deactivate();
        LOG.debug("Deactivating receipt of incoming messages");
        if (this.engine != null) {
            this.engine.removeServant(this.nurl);
        }
    }

    public String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.invoke(null, context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

