/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mail;

import java.io.File;
import java.net.MalformedURLException;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.test.integration.management.util.CLITestUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.common.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
@ServerSetup(value={MailSessionSetupTask.class})
public class MailExampleTest {
    private static final String GREENMAIL_WAR = "greenmail.war";
    private static final String EXAMPLE_CAMEL_MAIL_WAR = "example-camel-mail.war";
    private static final Logger LOG = LoggerFactory.getLogger((String)MailSessionSetupTask.class.getPackage().getName());
    @ArquillianResource
    Deployer deployer;

    @Deployment(managed=false, name="example-camel-mail.war")
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-mail.war"));
    }

    @Deployment(managed=false, testable=false, name="greenmail.war")
    public static WebArchive createGreenmailDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/greenmail-webapp.war"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendEmailTest() throws Exception {
        try {
            this.deployer.deploy(GREENMAIL_WAR);
            this.deployer.deploy(EXAMPLE_CAMEL_MAIL_WAR);
            StringBuilder endpointURL = new StringBuilder("from=user1@localhost");
            endpointURL.append("&to=user2@localhost").append("&subject=Greetings").append("&message=Hello");
            HttpRequest.HttpResponse result = HttpRequest.post((String)this.getEndpointAddress("/example-camel-mail/send")).header("Content-Type", "application/x-www-form-urlencoded").content(endpointURL.toString()).getResponse();
            String responseBody = result.getBody();
            Assert.assertTrue((String)("Sent successful: " + responseBody), (boolean)responseBody.contains("Message sent successfully"));
        }
        finally {
            this.deployer.undeploy(GREENMAIL_WAR);
            this.deployer.undeploy(EXAMPLE_CAMEL_MAIL_WAR);
        }
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath;
    }

    static class MailSessionSetupTask
    implements ServerSetupTask {
        public MailSessionSetupTask() {
            System.setProperty("jboss.dist", System.getProperty("jboss.home"));
        }

        public void setup(ManagementClient managementClient, String s) throws Exception {
            CommandContext ctx = CLITestUtil.getCommandContext();
            ctx.connectController();
            ctx.getBatchManager().activateNewBatch();
            Batch batch = ctx.getBatchManager().getActiveBatch();
            batch.add(ctx.toBatchedCommand("/socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp:add(host=localhost, port=10025)"));
            batch.add(ctx.toBatchedCommand("/socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3:add(host=localhost, port=10110)"));
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail:add(jndi-name=\"java:jboss/mail/greenmail\")"));
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail/server=smtp:add(outbound-socket-binding-ref=mail-greenmail-smtp, username=user1, password=password)"));
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail/server=pop3:add(outbound-socket-binding-ref=mail-greenmail-pop3, username=user2, password=password2)"));
            ModelNode request = batch.toRequest();
            batch.clear();
            ctx.getBatchManager().discardActiveBatch();
            ModelNode execute = managementClient.getControllerClient().execute(request);
            LOG.info(execute.toString());
        }

        public void tearDown(ManagementClient managementClient, String s) throws Exception {
            CommandContext ctx = CLITestUtil.getCommandContext();
            ctx.connectController();
            ctx.getBatchManager().activateNewBatch();
            Batch batch = ctx.getBatchManager().getActiveBatch();
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail/server=smtp:remove"));
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail/server=pop3:remove"));
            batch.add(ctx.toBatchedCommand("/subsystem=mail/mail-session=greenmail:remove"));
            batch.add(ctx.toBatchedCommand("/socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-smtp:remove"));
            batch.add(ctx.toBatchedCommand("/socket-binding-group=standard-sockets/remote-destination-outbound-socket-binding=mail-greenmail-pop3:remove"));
            ModelNode request = batch.toRequest();
            batch.clear();
            ctx.getBatchManager().discardActiveBatch();
            ModelNode execute = managementClient.getControllerClient().execute(request);
            LOG.info(execute.toString());
        }
    }
}

