/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
public class JPAExampleTest {
    private File destination = new File(System.getProperty("jboss.home") + "/standalone/data/customers");

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-jpa.war"));
    }

    @After
    public void tearDown() throws IOException {
        Files.walkFileTree(this.destination.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                exception.printStackTrace();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Test
    public void testFileToJpaRoute() throws Exception {
        String vmname = System.getProperty("java.vm.name");
        Assume.assumeFalse((boolean)vmname.contains("OpenJDK"));
        InputStream input = this.getClass().getResourceAsStream("/jpa/customer.xml");
        Files.copy(input, this.destination.toPath().resolve("customer.xml"), new CopyOption[0]);
        input.close();
        Thread.sleep(2000L);
        HttpRequest.HttpResponse result = HttpRequest.get((String)this.getEndpointAddress("/example-camel-jpa/customers")).getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("John Doe"));
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath;
    }
}

