/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jaxws;

import java.io.File;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;

@RunAsClient
@RunWith(value=Arquillian.class)
public class JaxwsExampleTest {
    private static final String ENDPOINT_ADDRESS = "http://localhost:8080/example-camel-jaxws/jaxws/";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.createFromZipFile(WebArchive.class, (File)new File("target/examples/example-camel-jaxws.war"));
    }

    @Test
    public void testJaxwsGreeting() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.post((String)ENDPOINT_ADDRESS).header("Content-Type", "application/x-www-form-urlencoded").content("name=Kermit").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("Hello Kermit"));
    }

    @Test
    public void testJaxwsGreetingWithMessage() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.post((String)ENDPOINT_ADDRESS).header("Content-Type", "application/x-www-form-urlencoded").content("name=Kermit&message=Goodbye").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("Goodbye Kermit"));
    }

    @Test
    public void testJaxwsGreetingWithoutNameOrMessage() throws Exception {
        HttpRequest.HttpResponse result = HttpRequest.post((String)ENDPOINT_ADDRESS).header("Content-Type", "application/x-www-form-urlencoded").content("name=&message=").getResponse();
        Assert.assertTrue((boolean)result.getBody().contains("Hello unknown"));
    }
}

