/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.test.AvailablePortFinder;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SftpIntegrationTest {
    private static final String FILE_BASEDIR = "basedir.txt";
    private static final Path FTP_ROOT_DIR = Paths.get("target/sftp", new String[0]);
    private static final int PORT = AvailablePortFinder.getNextAvailable((int)21000);
    private SshServer sshServer;

    @Deployment
    public static WebArchive createDeployment() throws IOException {
        File[] libraryDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("org.apache.sshd:sshd-sftp")).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-ftp-tests.war");
        archive.addAsResource((Asset)new StringAsset(System.getProperty("basedir")), FILE_BASEDIR);
        archive.addAsLibraries(libraryDependencies);
        SftpIntegrationTest.addJarHolding(archive, AvailablePortFinder.class);
        return archive;
    }

    @Before
    public void startSshServer() throws Exception {
        this.recursiveDelete(this.resolvePath(FTP_ROOT_DIR).toFile());
        this.sshServer = SshServer.setUpDefaultServer();
        this.sshServer.setPort(PORT);
        this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        this.sshServer.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
        this.sshServer.setCommandFactory((CommandFactory)new ScpCommandFactory());
        this.sshServer.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession serverSession) {
                return username.equals("admin") && password.equals("admin");
            }
        });
        this.sshServer.setPublickeyAuthenticator(new PublickeyAuthenticator(){

            public boolean authenticate(String s, PublicKey publicKey, ServerSession serverSession) {
                return false;
            }
        });
        this.sshServer.start();
    }

    @After
    public void stopSshServer() throws Exception {
        if (this.sshServer != null) {
            try {
                this.sshServer.stop();
                this.sshServer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendFile() throws Exception {
        File testFile = this.resolvePath(FTP_ROOT_DIR).resolve("test.txt").toFile();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            Endpoint endpoint = camelctx.getEndpoint("sftp://localhost:" + PORT + "/target/sftp?username=admin&password=admin");
            Assert.assertFalse((boolean)testFile.exists());
            camelctx.createProducerTemplate().sendBodyAndHeader(endpoint, (Object)"Hello", "CamelFileName", (Object)"test.txt");
            Assert.assertTrue((boolean)testFile.exists());
        }
        finally {
            camelctx.stop();
        }
    }

    private static void addJarHolding(WebArchive archive, Class<?> clazz) {
        File path;
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (location != null && location.getProtocol().equals("file") && (path = new File(location.getPath())).isFile()) {
            archive.addAsLibrary(path);
        }
    }

    private void recursiveDelete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    this.recursiveDelete(f);
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(Path other) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/basedir.txt")));){
            Path path = Paths.get(reader.readLine(), new String[0]).resolve(other);
            return path;
        }
    }
}

