/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jpa.JpaComponent;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.jpa.subA.Account;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class JpaTransactionManagerIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jpa-tests.jar");
        archive.addClass(Account.class);
        archive.addAsResource("jpa/persistence-local.xml", "META-INF/persistence.xml");
        archive.addAsResource("jpa/jpa-camel-context.xml", "META-INF/jboss-camel-context.xml");
        return archive;
    }

    @Test
    public void testJpaTransactionManagerRouteRoute() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("jpa-context");
        Assert.assertNotNull((String)"Expected jpa-context to not be null", (Object)camelctx);
        Account account = new Account(1, 500);
        camelctx.createProducerTemplate().sendBody("direct:start", (Object)account);
        JpaComponent component = (JpaComponent)camelctx.getComponent("jpa", JpaComponent.class);
        EntityManagerFactory entityManagerFactory = component.getEntityManagerFactory();
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        Account result = (Account)em.getReference(Account.class, (Object)1);
        em.getTransaction().commit();
        Assert.assertEquals((Object)account, (Object)result);
    }
}

