/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.xstream;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.xstream.subA.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class XStreamIntegrationTest {
    static String XML_STRING = "<firstName>John</firstName><lastName>Doe</lastName>";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"xstream-tests");
        archive.addClasses(new Class[]{Customer.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().xstream();
            }
        });
        String expected = this.wrapWithType(XML_STRING, Customer.class);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String customer = (String)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertTrue((String)("Contains " + expected + ": " + customer), (boolean)customer.contains(expected));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().xstream();
            }
        });
        String expected = this.wrapWithType(XML_STRING, Customer.class);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = (Customer)producer.requestBody("direct:start", (Object)expected, Customer.class);
            Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }

    private String wrapWithType(String xml, Class<?> type) {
        String fqn = type.getName();
        return "<" + fqn + ">" + xml + "</" + fqn + ">";
    }
}

